<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use App\Models\Users;
use App\Models\Slider;
use App\Models\AppOffer;
use App\Models\Video;
use App\Models\Web;
use App\Models\Task;
use App\Models\CoinStore;
use App\Models\Transaction;
use App\Models\_VideoWall;
use App\Models\_Subscriptions;
use App\Models\Weblink;
use App\Models\_Onboarding;
use App\Models\_Home;
use App\Models\TaskCount;
use App\User;
use Carbon\Carbon;
use GeoIP;
use Illuminate\Support\Facades\Auth;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Storage;
use File, Image;
use App\Http\Controllers\Api\MyAuth;
use Validator;

class Fun extends Controller
{

    private $timestamp;

    public function __construct()
    {
        $this->middleware('auth:api', ['except' => ['login', 'register', 'config', 'testapp', 'cronjob', 'offer_custom', 'offer_cr']]);
        $this->guard = "api";
        $this->timestamp = Carbon::now();
    }

    public function config(Request $req)
    {
        try {

            if ($json = MyAuth::Validation($req->field)) {
                $reqs = json_decode(base64_decode($json), true);

                $data = DB::table('tbl_setting')->where('id', 1)->get();
                $spin = DB::table('spin_wheel')->get();
                $cat = DB::table('home_category')->where('status', 0)->orderBy('row_order', 'ASC')->get();
                $home = _Home::where('status', 0)->orderBy('roworder', 'ASC')->get();

                if ($data) {
                    return response(['data' => $data, 'spin' => $spin, 'onboarding' => ($reqs['onboarding'] == false) ? _Onboarding::where('status', 0)->get() : [], 'home' => $home, 'cat' => $cat, 'code' => 201]);
                } else {
                    return response(['data' => 'data not found!!', 'code' => 400]);
                }
            } else {
                return response(['msg' => 'Something went wrong contact to Support ']);
            }
        } catch (\Exception $e) {
            return response(['msg' => 'Something went wrong contact to Support ']);
        }
    }

    public function promoBanner()
    {
        $data = Slider::where(['status' => 0])->where(['bannertype' => 'slide'])->select('banner', 'link', 'onclick')->get();
        if ($data) {
            return response(['data' => $data, 'code' => 201]);
        } else {
            return response(['data' => 'Data Not Found', 'code' => 401]);
        }
    }

    public function getSubscriptions()
    {
        if ($user = JWTAuth::User()) {
            $data = _Subscriptions::where('country', 'LIKE', '%' . $user->country . '%')->orWhere('country', '=', 'all')->where('status', 0)->orderBy('amount', 'ASC')->get();
            return response(['data' => $data]);
        }
    }

    public function getNative()
    {
        $data = DB::table('tbl_nativead')->where('status', 0)->inRandomOrder()->limit(10)->get();
        return response($data);
    }

    public function getPaymentGateway()
    {
        if ($user = JWTAuth::User()) {
            $data = DB::table('payment_gateway')->where('country', 'LIKE', '%' . $user->country . '%')->orWhere('country', '=', 'all')->where('status', 0)->orderBy('row_order', 'ASC')->get();
            return response($data);
        }
    }

    public function getSocialLinks()
    {
        $data = DB::table('links')->where('status', 0)->orderBy('roworder', 'ASC')->get();
        return response($data);
    }

    public function popupBanner()
    {
        $data = Slider::where(['status' => 0])->where('bannertype', '!=', 'slide')->select('banner', 'link', 'onclick')->get();
        if (count($data) > 0) {
            return response(['data' => $data, 'code' => 201]);
        } else {
            return response(['data' => [], 'code' => 401]);
        }
    }

    public function ofWeb()
    {
        if ($user = JWTAuth::User()) {
            $limit = $this->getTaskLimit($user->subscription, 'task_web');
            $taskCount = $this->getTaskCount($user->cust_id, 'c_web');

            if ($taskCount <= $limit) {
                ($limit - $taskCount > 15) ? $avil = 20 : $avil = $limit - $taskCount;
                $data = DB::select('Select weblink.id,title,url,status,point,ad_type,action_type,thumb,timer,weblink.type,country 
                            from weblink left outer join task on 
                        task.user_id =:ids and weblink.id = task.task_id and task.type=2 where
                        weblink.country Like :cn or weblink.country=:all and task.task_id is NULL
                        and weblink.status=0 ORDER BY weblink.type=:usr DESC limit :lim', ['ids' => $user->cust_id, 'cn' => '%' . $user->country . '%', 'all' => 'all', 'usr' => 'User', 'lim' => $avil]);
                return response()->json($data);
            } else {
                return [];
            }
        }
    }

    public function missions($id)
    {
        if ($user = JWTAuth::User()) {

            $sub = _Subscriptions::find($user->subscription);
            $db = DB::table('daily_mission')->where('status', 0)->orderBy('row_order', 'ASC')->get();
            $cnt = DB::table('task_count')->where('user_id', $user->cust_id)->get();
            $taskStatus = DB::select("SELECT user_id, COUNT(*) AS TOTAL, 
    COUNT(IF(task.task='m_daily',1,null)) AS m_daily,
    COUNT(IF(task.task='m_spin',1,null)) AS m_spin,
    COUNT(IF(task.task='m_web',1,null)) AS m_web,
    COUNT(IF(task.task='m_video',1,null)) AS m_video,
	COUNT(IF(task.task='m_videowall',1,null)) AS m_videowall,		    
    COUNT(IF(task.task='m_quiz',1,null)) AS m_quiz,
    COUNT(IF(task.task='m_scratch',1,null)) AS m_scratch
FROM task WHERE user_id=:uid and date(created_at)=:dat group by user_id", ['uid' => $id, 'dat' => date('Y-m-d')]);

            $appLimit = $sub->task_daily_offer;
            $spinLimit = $sub->task_spin;
            $webLimit = $sub->task_web;
            $videoLimit = $sub->task_video;
            $videozoneLimit = $sub->task_videozone;
            $quizLimit = $sub->task_quiz;
            $scratchLimit = $sub->task_scratch;

            $total = $appLimit + $spinLimit + $webLimit + $videoLimit + $videozoneLimit + $quizLimit + $scratchLimit;

            $crntApp = $cnt[0]->c_daily_offer;
            $crntSpin = $cnt[0]->c_spin;
            $crntWeb = $cnt[0]->c_web;
            $crntVideo = $cnt[0]->c_video;
            $crntVideoZone = $cnt[0]->c_videozone;
            $crntQuiz = $cnt[0]->c_quiz;
            $crntScratch = $cnt[0]->c_scratch;

            $left = $crntApp + $crntSpin + $crntWeb + $crntVideo + $crntVideoZone + $crntQuiz + $crntScratch;

            $data[0]['id'] = $db[0]->id;
            $data[0]['title'] = $db[0]->title;
            $data[0]['image'] = $db[0]->image;
            $data[0]['limit'] = $appLimit;
            $data[0]['count'] = $crntApp;
            $data[0]['status'] = (isset($taskStatus[0]->m_daily)) ? $taskStatus[0]->m_daily : 0;
            $data[0]['coin'] = $db[0]->coin;
            $data[0]['promo_coin'] = $db[0]->promo_coin;
            $data[0]['btn_name'] = $db[0]->btn_name;
            $data[0]['btn_action'] = $db[0]->btn_action;

            $data[1]['id'] = $db[1]->id;
            $data[1]['title'] = $db[1]->title;
            $data[1]['image'] = $db[1]->image;
            $data[1]['limit'] = $spinLimit;
            $data[1]['count'] = $crntSpin;
            $data[1]['status'] = (isset($taskStatus[0]->m_spin)) ? $taskStatus[0]->m_spin : 0;
            $data[1]['coin'] = $db[1]->coin;
            $data[1]['promo_coin'] = $db[1]->promo_coin;
            $data[1]['btn_name'] = $db[1]->btn_name;
            $data[1]['btn_action'] = $db[1]->btn_action;

            $data[2]['id'] = $db[2]->id;
            $data[2]['title'] = $db[2]->title;
            $data[2]['image'] = $db[2]->image;
            $data[2]['limit'] = $webLimit;
            $data[2]['count'] = $crntWeb;
            $data[2]['status'] = (isset($taskStatus[0]->m_web)) ? $taskStatus[0]->m_web : 0;
            $data[2]['coin'] = $db[2]->coin;
            $data[2]['promo_coin'] = $db[2]->promo_coin;
            $data[2]['btn_name'] = $db[2]->btn_name;
            $data[2]['btn_action'] = $db[2]->btn_action;

            $data[3]['id'] = $db[3]->id;
            $data[3]['title'] = $db[3]->title;
            $data[3]['image'] = $db[3]->image;
            $data[3]['limit'] = $videoLimit;
            $data[3]['count'] = $crntVideo;
            $data[3]['status'] = (isset($taskStatus[0]->m_video)) ? $taskStatus[0]->m_video : 0;
            $data[3]['coin'] = $db[3]->coin;
            $data[3]['promo_coin'] = $db[3]->promo_coin;
            $data[3]['btn_name'] = $db[3]->btn_name;
            $data[3]['btn_action'] = $db[3]->btn_action;

            $data[4]['id'] = $db[4]->id;
            $data[4]['title'] = $db[4]->title;
            $data[4]['image'] = $db[4]->image;
            $data[4]['limit'] = $videozoneLimit;
            $data[4]['count'] = $crntVideoZone;
            $data[4]['status'] = (isset($taskStatus[0]->m_videowall)) ? $taskStatus[0]->m_videowall : 0;
            $data[4]['coin'] = $db[4]->coin;
            $data[4]['promo_coin'] = $db[4]->promo_coin;
            $data[4]['btn_name'] = $db[4]->btn_name;
            $data[4]['btn_action'] = $db[4]->btn_action;

            $data[5]['id'] = $db[5]->id;
            $data[5]['title'] = $db[5]->title;
            $data[5]['image'] = $db[5]->image;
            $data[5]['limit'] = $quizLimit;
            $data[5]['count'] = $crntQuiz;
            $data[5]['status'] = (isset($taskStatus[0]->m_quiz)) ? $taskStatus[0]->m_quiz : 0;
            $data[5]['coin'] = $db[5]->coin;
            $data[5]['promo_coin'] = $db[5]->promo_coin;
            $data[5]['btn_name'] = $db[5]->btn_name;
            $data[5]['btn_action'] = $db[5]->btn_action;

            $data[6]['id'] = $db[6]->id;
            $data[6]['title'] = $db[6]->title;
            $data[6]['image'] = $db[6]->image;
            $data[6]['limit'] = $scratchLimit;
            $data[6]['count'] = $crntScratch;
            $data[6]['status'] = (isset($taskStatus[0]->m_scratch)) ? $taskStatus[0]->m_scratch : 0;
            $data[6]['coin'] = $db[6]->coin;
            $data[6]['promo_coin'] = $db[6]->promo_coin;
            $data[6]['btn_name'] = $db[6]->btn_name;
            $data[6]['btn_action'] = $db[6]->btn_action;

            $resp = [
                'data' => $data,
                'total' => $total,
                'left' => $left
            ];


            return response()->json($resp);
        }
    }

    public function ofVideo()
    {
        if ($user = JWTAuth::User()) {
            $limit = $this->getTaskLimit($user->subscription, 'task_video');
            $taskCount = $this->getTaskCount($user->cust_id, 'c_video');

            if ($taskCount <= $limit) {
                ($limit - $taskCount > 15) ? $avil = 20 : $avil = $limit - $taskCount;
                $data = DB::select('Select youtube_video.id,title,timer,status,point,url,thumb,ad_type,action_type,task_limit,youtube_video.type,country 
                from youtube_video left outer join task on task.user_id =:ids 
                    and youtube_video.id = task.task_id and task.type=2
                    where youtube_video.country Like :cn or youtube_video.country=:all                         
                    and task.task_id is NULL
                    and youtube_video.status=0 ORDER BY youtube_video.type=:usr DESC limit :lim', ['ids' => $user->cust_id, 'cn' => '%' . $user->country . '%', 'all' => 'all', 'usr' => 'User', 'lim' => $avil]);
                return response()->json($data);
            } else {
                return [];
            }
        }
    }

    public function videowall()
    {
        if ($user = JWTAuth::User()) {
            $limit = $this->getTaskLimit($user->subscription, 'task_videozone');
            $taskCount = $this->getTaskCount($user->cust_id, 'c_videozone');

            if ($taskCount <= $limit) {
                return response()->json(['data' => _VideoWall::where('status', 0)->orderBy('row_order', 'ASC')->get(), 'code' => 201]);
            } else {
                return response()->json(['code' => 202, 'msg' => 'Today Limit Completed']);
            }
        }
    }

    public function ofCustom()
    {
        if ($user = JWTAuth::User()) {
            $data = DB::select('SELECT appsname.id,appsname.offer_id,app_name,image,points,appurl,details,p_userid,appsname.appID,offer_type,appsname.status,country, `appslog`.`user_id`, `appslog`.`status`  FROM `appsname` LEFT OUTER JOIN `appslog` ON `appslog`.`user_id` =:ids AND `appslog`.`appid` = `appsname`.`id` and `appslog`.`status` = 0 WHERE `appsname`.`country` LIKE :cn OR `appsname`.`country` = :all AND `appslog`.`appid` IS NULL AND `appsname`.`status` = 0 ORDER BY `appsname`.`points` LIMIT :lim', ['ids' => $user->cust_id, 'cn' => '%' . $user->country . '%', 'all' => 'all', 'lim' => 15]);

            return response()->json($data);
        } else {
            return response()->json([]);
        }
    }

    public function dailyoffer()
    {
        if ($user = JWTAuth::User()) {
            $limit = $this->getTaskLimit($user->subscription, 'task_daily_offer');
            $taskCount = $this->getTaskCount($user->cust_id, 'c_daily_offer');

            if ($taskCount <= $limit) {
                ($limit - $taskCount > 15) ? $avil = 20 : $avil = $limit - $taskCount;
                $data = DB::select('Select tbl_dailyoffer.id,title,coin,tbl_dailyoffer.image,tbl_dailyoffer.link,country,description
                            from tbl_dailyoffer left outer join data_dailyoffer on 
                        data_dailyoffer.user_id =:ids and tbl_dailyoffer.id = data_dailyoffer.survey_id
                        where tbl_dailyoffer.status=0 and
                        tbl_dailyoffer.country Like :cn or tbl_dailyoffer.country=:all
                        and data_dailyoffer.survey_id is NULL
                        ORDER BY tbl_dailyoffer.id DESC limit :lim', ['ids' => $user->cust_id, 'cn' => '%' . $user->country . '%', 'all' => 'all', 'lim' => $avil]);
                return response()->json($data);
            }
        }
    }

    public function ofCustomProgress()
    {
        $user = JWTAuth::User();

        $data = DB::table('appsname')
            ->join('appslog', 'appslog.appid', '=', 'appsname.id')
            ->select('app_name', 'details', 'appsname.image', 'appsname.points', 'appslog.user_id')
            ->where('appslog.user_id', '=', $user->cust_id)
            ->orderBy('appslog.id', 'DESC')->limit(15)->get();

        return response()->json($data);
    }

    // Api Start
    public function api(Request $reqs)
    {
        if ($user = JWTAuth::User()) {
            if ($json = MyAuth::Validation($reqs->data)) {
                $req = json_decode(base64_decode($json), true);
                $type = $req['type'];
                $userid = base64_decode($req['im']);
                $reward = $req['reward'];
                $tag = $req['tag'];
                $modelID = $req['id'];

                switch ($type) {
                        // daily checkin
                    case "dailycheck":
                        return $this->dailycheck($user);
                        break;

                    case "s-limit":
                        return $this->ftlimt($user, $tag);
                        break;

                    case "s-credit":
                        return $this->crMulti($user, $tag, $reward);
                        break;

                    case "referBonus":
                        return $this->collectBonus($user, $reward);
                        break;

                        // video wall credit 
                    case "videowall":
                        return $this->creditVideowall($user, $modelID);
                        break;

                        // video credit 
                    case "video":
                        return $this->creditVideo($user, $modelID);
                        break;

                        // web credit 
                    case "web":
                        return $this->creditWeb($user, $modelID);
                        break;

                        // playzone credit 
                    case "playzone":
                        return $this->creditPlayzone($user, $modelID);
                        break;

                        // promo config 
                    case "PromoConfig":
                        return $this->PromoConfig($user);
                        break;

                        // promo video 
                    case "PromoData":
                        return $this->getPromoData($tag, $user);
                        break;

                        // promo video 
                    case "refreshCoin":
                        return response(['balance' => $user->balance, 'code' => 201]);
                        break;

                        // read global msg 
                    case "readGlobal":
                        return $this->readGlobalMsg($modelID, $user->cust_id);
                        break;

                    case "missionValidation":
                        return $this->validateDailyMission($user->cust_id, $modelID);
                        break;

                    case "moveCpi":
                        return $this->moveTaskPending($user->cust_id, $modelID);
                        break;

                    case "revealScratch":
                        return $this->revealScratch($user, $modelID);
                        break;

                    case "validateContest":
                        return $this->validateContest($user, $modelID);
                        break;

                        //user,redeem id,userdata    
                    case "redeem":
                        return $this->redeem($user, $modelID, $tag);
                        break;

                    case "profileInfo":
                        return $this->profileInfo($user);
                        break;
                }
            } else {
                return response(['msg' => 'Invalid Response']);
            }
        } else {
            return $this->respError("Session Expired Please Login Again");
        }
    }

    public function profileInfo($user)
    {

        if ($user->expired_at > date('Y-m-d')) {
            $status = 'Active';
        } else {
            $status = 'Expired';
        }

        if ($sub = DB::table('subscriptions')->where('id', $user->subscription)->first()) {
            return response(['balance' => $user->balance, 'data1' => $user->expired_at, 'data2' => $user->purchased_at, 'title' => $sub->title, 'image' => $sub->image, 'code' => 201, 'id' => $user->subscription, 'status' => $status]);
        } else {
            return response(['balance' => $user->balance, 'data1' => $user->expired_at, 'data2' => $user->purchased_at, 'code' => 202, 'id' => $user->subscription, 'status' => $status]);
        }
    }

    function readGlobalMsg($modelID, $userid)
    {
        DB::table('global_msg')->where('user_id', $userid)->update(['status' => 1]);
        return response(['msg' => 'Global Msg Read']);
    }

    //new
    function creditVideowall($user, $modelID)
    {
        if ($video = DB::table('videowall')->where(['id' => $modelID, 'status' => 0])->get()) {

            $limit = $this->getTaskLimit($user->subscription, 'task_videozone');
            $taskCount = $this->getTaskCount($user->cust_id, 'c_videozone');

            if ($taskCount > $limit) {
                return response()->json(['msg' => "Today Limit Completed For More Task Please Upgrade plan", 'code' => 202]);
            }

            $total = $user->balance + $video[0]->coin;
            $user->balance = $total;
            $user->Save();

            $this->intTrans("Videowall", $user->cust_id, $video[0]->coin, $total, $video[0]->coin . " Bonus Received");
            $this->updateTaskCount($user->cust_id, 'c_videozone', $taskCount + 1);

            return response()->json(['msg' =>  $video[0]->coin . " Bonus Received", 'limit' => $limit - $taskCount + 1, 'balance' => $total, 'coin' => $video[0]->coin, 'code' => 201]);
        } else {
            return $this->respError("Sorry currently the video is not available");
        }
    }

    function PromoConfig($user)
    {
        $info = DB::table('tbl_app_setting')->where('id', 1)->select('max_promote', 'video_promotecoin', 'promo_webcoin')->get();
        return response()->json([
            'balance' => $user->promo_balance,
            'data1' => $info[0]->max_promote,
            'data2' => $info[0]->video_promotecoin,
            'code' => 201
        ]);
    }

    function getPromoData($tag, $user)
    {
        if ($tag == "web") {
            return response()->json(Web::where('userid', $user->cust_id)->select('title', 'task_limit', 'views', 'insert_at', 'thumb')->get());
        } else {
            return response()->json(Video::where('userid', $user->cust_id)->select('title', 'task_limit', 'views', 'insert_at', 'thumb')->get());
        }
    }

    function getTaskCount($uid, $type)
    {
        $cnt = DB::table('task_count')->where('user_id', $uid)->select($type)->get();
        return $cnt[0]->$type;
    }

    function updateTaskCount($uid, $type, $val)
    {
        DB::table('task_count')->where('user_id', $uid)->update([$type => $val]);
    }

    function getTaskLimit($subid, $type)
    {
        $cnt = DB::table('subscriptions')->where('id', $subid)->select($type)->get();
        return $cnt[0]->$type;
    }

    function collectBonus($user, $refid)
    {
        if ($user = JWTAuth::User()) {

            $setting = DB::table('tbl_app_setting')->where('id', 1)->select('welcome_bonus', 'refer_mode')->get();
            $bonus = $setting[0]->welcome_bonus;

            if ($refid == $user->refferal_id) {
                return $this->respError($msg[1]->description);
            } else if ($user->from_refer != null || $user->from_refer > 0) {
                return $this->respError("Bonus Already Collected");
            }

            $wb = explode('-', $setting[0]->welcome_bonus);

            if ($setting[0]->refer_mode == "direct") {
                $coin = $wb[1];
            } else {
                $coin = $wb[1] / 2;
            }

            $coin = rand($wb[0], $coin);

            if ($user->from_refferal_id > 0) {
                return $this->respError('You have already used Referral code.');
            } else if ($refid == null) {
                return $this->respError("Please Enter Valid Referral Code");

                /*$user->from_refferal_id = 1;
                $user->refer = true;
                $user->save();

                DB::table('scratch_card')->insert(['user_id' => $user->cust_id, 'coin' => $coin, 'remark' => 'Welcome Bonus']);

                return $this->respOk("Congratulation You Won Scratch Card", 0);*/
            } else {

                if ($checkRef = Users::where('refferal_id', $refid)->first()) {
                    $user->from_refferal_id = $refid;

                    if ($setting[0]->refer_mode == "direct") {
                        $sub = _Subscriptions::where('id', $checkRef->subscription)->select('refer_bonus')->get();
                        $exp = explode("-", $sub[0]->refer_bonus);
                        $fromcoin = rand($exp[0], $exp[1]);

                        DB::table('scratch_card')->insert([
                            'user_id' => $checkRef->cust_id,
                            'coin' => $fromcoin,
                            'remark' => 'Referral Bonus Credit From ' . $checkRef->name
                        ]);

                        if ($crnt = DB::table('contest_record')->where('user_id', $checkRef->cust_id)->whereDate('created_at', date('Y-m-d'))->first()) {
                            DB::table('contest_record')->where('id', $crnt->id)->update([
                                'user_id' => $checkRef->cust_id,
                                'to_user_id' => $user->cust_id,
                                'task_count' => ($crnt->task_count + 1),
                            ]);
                        } else {
                            DB::table('contest_record')->insert([
                                'user_id' => $checkRef->cust_id,
                                'to_user_id' => '1',
                                'task_count' => 1,
                            ]);
                        }

                        DB::table('global_msg')->insert([
                            'user_id' => $checkRef->cust_id,
                            'title' => 'Congratulations',
                            'msg' => 'You Won Scratch Card for Invite your friend ' . $checkRef->name,
                            'btn_name' => 'Open Scratch Card',
                            'btn_action' => 'invite',
                            'error' => 'false'
                        ]);

                        $user->refer = true;
                        DB::table('scratch_card')->insert(['user_id' => $user->cust_id, 'coin' => $coin, 'remark' => 'Welcome Bonus']);
                    } else {

                        $exp = explode("-", $sub[0]->welcome_bonus);
                        $fromcoin = rand($exp[0], $exp[1]);

                        DB::table('global_msg')->insert([
                            'user_id' => $user->cust_id,
                            'title' => 'Congratulations',
                            'msg' => 'You Won Scratch Card from your Friend ' . $checkRef->name,
                            'btn_name' => 'Open Scratch Card',
                            'btn_action' => 'invite',
                            'error' => 'false'
                        ]);

                        $user->refer = true;
                        DB::table('scratch_card')->insert(['user_id' => $user->cust_id, 'coin' => $coin, 'remark' => 'Welcome Bonus Part 1']);
                    }
                    $user->save();

                    return $this->respOk("Congratulation You Won Scratch Card", $user->balance);
                } else {
                    return $this->respError("Please Enter Valid Referral Code");
                }
            }
        } else {
            return $this->respError("Something went wrong");
        }
    }

    function crMulti($user, $type, $c)
    {
        if ($user = JWTAuth::User()) {

            $sub = _Subscriptions::where('id', $user->subscription)->select('task_spin', 'task_scratch', 'task_quiz')->get();
            $taskCnt = TaskCount::find($user->cust_id);

            if ($type == "spin") {

                if ($taskCnt->c_spin <= $sub[0]->task_spin) {
                    $taskCnt->c_spin += +1;
                    $tot = $user->balance + $c;
                    $taskCnt->save();
                    $user->balance = $tot;
                    $user->save();
                    $this->intTrans("Lucky Wheel", $user->cust_id, $c, $tot, $c . " Bonus Received");

                    $setting = DB::table('tbl_app_setting')->where('id', 1)->select('spin_interval', 'spin_adinterval', 'spin_ad')->get();
                    $interval = $setting[0]->spin_interval;
                    $adinerval = $setting[0]->spin_adinterval;
                    $ad = $setting[0]->spin_ad;
                    $coin = 0;

                    return response()->json(['msg' => $c . " Bonus Received", 'limit' => $sub[0]->task_spin - $taskCnt->c_spin, 'balance' => $tot, 'coin' => $coin, 'interval' => $interval, 'ad_interval' => $adinerval, 'adType' => $ad, 'code' => 201]);
                } else {
                    return $this->respError("Today No Spin Left");
                }
            } else if ($type == "scratch") {
                if ($taskCnt->c_scratch <= $sub[0]->task_scratch) {
                    $taskCnt->c_scratch += +1;
                    $taskCnt->save();
                    $tot = $user->balance + $c;
                    $user->balance = $tot;
                    $user->save();
                    $this->intTrans("Scratch Card", $user->cust_id, $c, $tot, $c . " Bonus Received");

                    $setting = DB::table('tbl_app_setting')->where('id', 1)->select('scratch_coin', 'scratch_interval', 'scratch_adinterval', 'scratch_ad')->get();
                    $interval = $setting[0]->scratch_interval;
                    $adinerval = $setting[0]->scratch_adinterval;
                    $ad = $setting[0]->scratch_ad;
                    $coin = $setting[0]->scratch_coin;

                    return response()->json(['msg' => $c . " Bonus Received", 'limit' => $sub[0]->task_scratch - $taskCnt->c_scratch, 'balance' => $tot, 'coin' => $coin, 'interval' => $interval, 'ad_interval' => $adinerval, 'adType' => $ad, 'code' => 201]);
                } else {
                    return $this->respError("Today No Scratch Card Left");
                }
            } else if ($type == "quiz") {
                if ($taskCnt->c_quiz <= $sub[0]->task_quiz) {

                    $setting = DB::table('tbl_app_setting')->where('id', 1)->select('quiz_coin', 'quiz_interval', 'quiz_adinterval', 'quiz_ad')->get();

                    $a = explode("-", $setting[0]->quiz_coin);
                    $c = rand($a[0], $a[1]);
                    $taskCnt->c_quiz += +1;
                    $taskCnt->save();
                    $tot = $user->balance + $c;
                    $user->balance = $tot;
                    $user->save();
                    $this->intTrans("Quiz", $user->cust_id, $c, $tot, $c . " Bonus Received");

                    $interval = $setting[0]->quiz_interval;
                    $adinerval = $setting[0]->quiz_adinterval;
                    $ad = $setting[0]->quiz_ad;
                    $coin = $setting[0]->quiz_coin;

                    return response()->json(['msg' => $c . " Bonus Received", 'limit' => $sub[0]->task_quiz - $taskCnt->c_quiz, 'balance' => $tot, 'coin' => $coin, 'interval' => $interval, 'ad_interval' => $adinerval, 'adType' => $ad, 'code' => 201]);
                } else {
                    return $this->respError("Today No Quiz Left");
                }
            }
        }
    }

    function ftlimt($user, $type)
    {
        $user = JWTAuth::User();
        $sub = _Subscriptions::where('id', $user->subscription)->select('task_spin', 'task_scratch', 'task_quiz')->get();
        $taskCnt = TaskCount::find($user->cust_id);
        switch ($type) {
            case "spin":
                $t = $sub[0]->task_spin;
                $u = $taskCnt->c_spin;
                $setting = DB::table('tbl_app_setting')->where('id', 1)->select('spin_interval', 'spin_adinterval', 'spin_ad')->get();

                $interval = $setting[0]->spin_interval;
                $adinerval = $setting[0]->spin_adinterval;
                $ad = $setting[0]->spin_ad;
                $coin = 0;
                break;

            case "scratch":
                $t = $sub[0]->task_scratch;
                $u = $taskCnt->c_scratch;
                $setting = DB::table('tbl_app_setting')->where('id', 1)->select('scratch_coin', 'scratch_interval', 'scratch_adinterval', 'scratch_ad')->get();

                $interval = $setting[0]->scratch_interval;
                $adinerval = $setting[0]->scratch_adinterval;
                $ad = $setting[0]->scratch_ad;
                $coin = $setting[0]->scratch_coin;
                break;

            case "quiz":
                $t = $sub[0]->task_quiz;
                $u = $taskCnt->c_quiz;
                $setting = DB::table('tbl_app_setting')->where('id', 1)->select('quiz_coin', 'quiz_interval', 'quiz_adinterval', 'quiz_ad')->get();

                $interval = $setting[0]->quiz_interval;
                $adinerval = $setting[0]->quiz_adinterval;
                $ad = $setting[0]->quiz_ad;
                $coin = $setting[0]->quiz_coin;
                break;
        }

        if ($u <= $t) {
            return response()->json(['total' => $t, 'limit' => $t - $u, 'coin' => $coin, 'interval' => $interval, 'ad_interval' => $adinerval, 'adType' => $ad, 'code' => 201]);
        } else {
            return response()->json(['total' => $t, 'limit' => 0, 'code' => 401]);
        }
    }

    public function testapp()
    {




        // return $data = DB::table('appsname')
        //     ->join('appslog', 'appslog.appid', '=', 'appsname.id')
        //     ->select('appsname.*', 'appslog.user_id','appslog.status')
        //     ->where(['appslog.user_id'=>3030,'appslog.status'=>0,'appsname.status'=>0])
        //     ->where('appslog.appid','=',NULL)
        //     ->where('appsname.country','Like','%IN%')
        //     ->orwhere('appsname.country','all')
        //     ->orderBy('appsname.points', 'DESC')->limit(15)->get();


    }

    public function leaderboard($type)
    {
        $msg = "";
        $date = date('Y-m-d');
        switch ($type) {
                // 0 = daily,1=weekly,2=alltime
            case 0:
                $data = DB::select("SELECT DISTINCT(user_id), SUM(amount) as balance,customer.name,customer.country,customer.profile FROM `transaction` left outer join customer on customer.cust_id=transaction.user_id WHERE transaction.tran_type='credit' and date(transaction.inserted_at)=:dat GROUP BY customer.name ORDER BY balance DESC LIMIT 50", ['dat' => date('Y-m-d')]);

                $app = DB::table('tbl_app_setting')->where('id', 1)->select('daily_leaderboard1', 'daily_leaderboard2', 'daily_leaderboard3')->get();
                $msg = 'Top #1 = ' . $app[0]->daily_leaderboard1 . ' Coin ,#2 =' . $app[0]->daily_leaderboard2 . ' Coin ,#3 =' . $app[0]->daily_leaderboard3 . ' will get Bonus';

                break;

            case 1:

                $data = DB::select("SELECT DISTINCT(user_id), SUM(amount) as balance,customer.name,customer.country,customer.profile FROM transaction left outer join customer on customer.cust_id=transaction.user_id WHERE transaction.tran_type='credit' and date(transaction.inserted_at)>=:start AND date(transaction.inserted_at) <=:end GROUP BY user_id ORDER BY balance DESC LIMIT 50", ['start' => date('Y-m-d', strtotime("this week")), 'end' => date('Y-m-d', strtotime("sunday this week", strtotime($date)))]);


                $app = DB::table('tbl_app_setting')->where('id', 1)->select('weekly_leaderboard1', 'weekly_leaderboard2', 'weekly_leaderboard3')->get();
                $msg = 'Top #1 = ' . $app[0]->weekly_leaderboard1 . ' Coin ,#2 =' . $app[0]->weekly_leaderboard2 . ' Coin ,#3 =' . $app[0]->weekly_leaderboard3 . ' will get Bonus';

                break;

            case 2:
                $data = DB::table('customer')
                    ->select('customer.name', 'customer.subscription', 'customer.balance', 'customer.profile', 'customer.type')
                    ->orderBy('customer.balance', 'DESC')
                    ->take('50')
                    ->get();



                break;
        }

        if ($data) {
            return response()->json(['data' => $data, 'msg' => $msg, 'code' => 201]);
        } else {
            return response()->json(['data' => 'Data Not Found', 'msg' => $msg, 'code' => 404]);
        }
    }

    function redeem($user, $id, $userdata)
    {

        $rd = DB::table('redeem')->where('id', $id)->select('title', 'points', 'refer', 'task', 'quantity', 'category')->get();
        if ($rd) {
            if ($user->status == 1) {
                return $this->respError($user->reason);
            }

            if ($user->balance >= $rd[0]->points) {

                $redeemLimit = DB::table('tbl_app_setting')->where('id', 1)->select('redeem_limit', 'refer_mode')->get();
                $rchk = DB::table('recharge_request')->where('user_id', $user->cust_id)->whereDate('date', date('Y-m-d'))->count();

                if ($rchk >= $redeemLimit[0]->redeem_limit) {
                    return $this->respError('Oops You Today Redeem Limit is Completed.');
                }

                if ($rd[0]->quantity != "00" && $rd[0]->quantity == 0) {
                    return $this->respError('You are to Late No Stock Left wait for few days or try with Different Option.');
                }

                if ($rd[0]->refer > 0) {
                    $cref = Users::where('from_refferal_id', $user->refferal_id)->count();
                    if ($cref < $rd[0]->refer) {
                        return $this->respError('Invite ' . $rd[0]->refer . ' Unlock this Redeem');
                    }
                }

                if ($rd[0]->task > 0) {

                    $getTaskLimit = DB::table('subscriptions')->where('id', $user->subscription)->select('task_web', 'task_video', 'task_quiz', 'task_spin', 'task_scratch')->get();
                    $taskCount = DB::table('task_count')->where('user_id', $user->cust_id)->select('c_spin', 'c_scratch', 'c_quiz', 'c_video', 'c_web')->get();

                    switch ($rd[0]->task) {
                        case 1:
                            if ($taskCount[0]->c_spin < $getTaskLimit[0]->task_spin || $taskCount[0]->c_scratch < $getTaskLimit[0]->task_scratch) {
                                return $this->respError('To Unlock this Redeem You Need to Complete Lucky wheel ,Scratch Card Task');
                            }
                            break;

                        case 2:
                            if ($taskCount[0]->c_spin < $getTaskLimit[0]->task_spin || $taskCount[0]->c_scratch < $getTaskLimit[0]->task_scratch || $taskCount[0]->c_quiz < $getTaskLimit[0]->task_quiz) {
                                return $this->respError('To Unlock this Redeem You Need to Complete this Task = Lucky wheel,Scratch Card, Math Quiz Task');
                            }
                            break;

                        case 3:
                            if ($taskCount[0]->c_spin < $getTaskLimit[0]->task_spin || $taskCount[0]->c_scratch < $getTaskLimit[0]->task_scratch || $taskCount[0]->c_web < $getTaskLimit[0]->task_web) {
                                return $this->respError('To Unlock this Redeem You Need to Complete this Task = Lucky wheel,Scratch Card, Read Article Task');
                            }
                            break;

                        case 4:
                            if ($taskCount[0]->c_spin < $getTaskLimit[0]->task_spin || $taskCount[0]->c_scratch < $getTaskLimit[0]->task_scratch || $taskCount[0]->c_web < $getTaskLimit[0]->task_web || $taskCount[0]->c_video < $getTaskLimit[0]->task_video) {
                                return $this->respError('To Unlock this Redeem You Need to Complete this Task = Lucky wheel,Scratch Card, Read Article, VideoZone Task');
                            }
                            break;
                    }
                }

                $ins = DB::table('recharge_request')->insert([
                    'mobile_no' => $userdata,
                    'amount' => $rd[0]->points,
                    'type' => $rd[0]->title,
                    'user_id' => $user->cust_id,
                    'status' => 'Pending',
                    'c_id' => $rd[0]->category,
                    'r_id' => $id,
                    'ip' => Fun::IpAddr(),
                    'date' => Carbon::now()
                ]);

                if ($ins) {
                    $ded = $user->balance - $rd[0]->points;
                    $user->balance = $ded;

                    if ($rd[0]->quantity != "00" && $rd[0]->quantity > 0) {
                        DB::table('redeem')->where('id', $id)->update(['quantity' => ($rd[0]->quantity - 1)]);
                    }

                    DB::table('transaction')->insert([
                        'tran_type' => 'credit',
                        'type' => 'Withdrawal',
                        'user_id' =>  $user->cust_id,
                        'amount' => $rd[0]->points,
                        'ip' => Fun::IpAddr(),
                        'remained_balance' => $ded,
                        'remarks' => 'Withdrawal Request Submit',
                        'inserted_at' => Carbon::now()
                    ]);


                    if ($user->refer == false & $redeemLimit[0]->refer_mode != 'direct') {
                        $user->refer = true;
                        if ($checkRef = Users::where('from_refferal_id', $user->from_refferal_id)->first()) {

                            $sub = _Subscriptions::where('id', $checkRef->subscription)->select('refer_bonus')->get();
                            $exp = explode("-", $sub[0]->refer_bonus);
                            $fromcoin = rand($exp[0], $exp[1]);

                            DB::table('scratch_card')->insert([
                                'user_id' => $checkRef->cust_id,
                                'coin' => $fromcoin,
                                'remark' => 'Referral Bonus Credit From ' . $checkRef->name
                            ]);

                            if ($crnt = DB::table('contest_record')->where('user_id', $checkRef->cust_id)->whereDate('created_at', date('Y-m-d'))->first()) {
                                DB::table('contest_record')->where('id', $crnt->id)->update([
                                    'user_id' => $checkRef->cust_id,
                                    'to_user_id' => $user->cust_id,
                                    'task_count' => ($crnt->task_count + 1),
                                ]);
                            } else {
                                DB::table('contest_record')->insert([
                                    'user_id' => $checkRef->cust_id,
                                    'to_user_id' => '1',
                                    'task_count' => 1,
                                ]);
                            }

                            DB::table('global_msg')->insert([
                                'user_id' => $paytrans[0]->user_id,
                                'title' => 'Congratulations',
                                'msg' => 'You Won Scratch Card for Invite your friend ' . $checkRef->name,
                                'btn_name' => 'Open Scratch Card',
                                'btn_action' => 'invite',
                                'error' => 'false'
                            ]);
                        }
                    }

                    $user->save();
                    return $this->respOk('Redeem Successfully you will receive with in 48 Hours.', $ded);
                } else {
                    return $this->respError('Something went wrong');
                }
            } else {
                return $this->respError('Not Enough Coin to Redeem');
            }
        } else {
            return $this->respError('Error 002');
        }
    }

    public function getContest($id, $limit)
    {
        if ($user = JWTAuth::User()) {

            $data = DB::select('Select contest_task.id,title,image,expired_at,start_from,task_require,coin,contest_task.status,contest_completed.contest_status from contest_task left outer join contest_completed on contest_completed.user_id =:ids and contest_task.id = contest_completed.contest_id where contest_completed.contest_id is NULL and contest_task.status=0 ORDER BY contest_task.task_require ASC limit :lim', ['ids' => $user->cust_id, 'lim' => $limit]);
            $res = array();
            foreach ($data as $key => $value) {
                $checkRecord = DB::select('SELECT SUM(task_count) as total FROM `contest_record` WHERE user_id=:uid and date(created_at) >=:dat', ['uid' => $user->cust_id, 'dat' => $value->start_from]);

                $res[$key]['id'] = $value->id;
                $res[$key]['title'] = $value->title;
                $res[$key]['image'] = $value->image;
                $res[$key]['expired_at'] = $value->expired_at;
                $res[$key]['start_from'] = $value->start_from;
                $res[$key]['task_require'] = $value->task_require;
                $res[$key]['coin'] = $value->coin;
                $res[$key]['contest_status'] = $value->contest_status;
                $res[$key]['refer'] = (isset($checkRecord[0]->total)) ? $checkRecord[0]->total : 0;
            }

            return response()->json(['data' => $res, 'code' => 201]);
        } else {
            return response()->json(['code' => 404]);
        }
    }

    public function revealScratch($user, $modelID)
    {

        if ($scratch = DB::table('scratch_card')->where(['id' => $modelID, 'status' => 0])->first()) {
            $total = $user->balance + $scratch->coin;
            $user->balance = $total;

            DB::table('transaction')->insert([
                'tran_type' => 'credit',
                'type' => 'Invite',
                'user_id' =>  $user->cust_id,
                'amount' => $scratch->coin,
                'ip' => Fun::IpAddr(),
                'remained_balance' => $scratch->coin,
                'remarks' => $scratch->remark,
                'inserted_at' => Carbon::now()
            ]);

            $user->save();
            DB::table('scratch_card')->where('id', $modelID)->update(['status' => 1]);
            return $this->respOk("You Won " . $scratch->coin, $total);
        } else {
            return $this->respError('Scratch Card Not Exist or Already Claimed');
        }
    }

    public function referScratchCard($id, $limit)
    {
        if ($user = JWTAuth::User()) {
            $data = DB::table('scratch_card')->where(['user_id' => $user->cust_id])->limit($limit)->orderBy('id', 'DESC')->get();

            $sub = _Subscriptions::where('id', $user->subscription)->select('refer_bonus')->get();
            $exp = explode("-", $sub[0]->refer_bonus);

            $wl = DB::table('tbl_app_setting')->where('id', 1)->select('welcome_bonus', 'refer_point1', 'refer_point2', 'refer_point3', 'refer_mode')->get();
            $wlb = explode("-", $wl[0]->welcome_bonus);

            $successRef = Users::where(['from_refferal_id' => $user->refferal_id, 'refer' => true])->count();
            $pendingRef = Users::where(['from_refferal_id' => $user->refferal_id, 'refer' => false])->count();

            $ar = [
                'data' => $data,
                'refer_mode' => $wl[0]->refer_mode,
                'successRef' => $successRef,
                'pendingRef' => $pendingRef,
                'welcome_bonus' => $wlb[1],
                'refer_bonus' => $exp[1],
                'refer_point1' => $wl[0]->refer_point1,
                'refer_point2' => $wl[0]->refer_point2,
                'refer_point3' => $wl[0]->refer_point3,
                'code' => 201
            ];

            return response()->json($ar);
        } else {
            return response()->json([]);
        }
    }

    public function validateContest($user, $id)
    {
        $uid = $user->cust_id;
        $check = DB::table('contest_completed')->where(['user_id' => $uid, 'contest_id' => $id])->count();

        if ($check > 0) {
            return $this->respError("Contest bonus already claimed");
        }

        $contest = DB::table('contest_task')->where('id', $id)->select('title', 'coin', 'task_require', 'start_from', 'expired_at')->get();
        if ($contest) {
            $date = date('Y-m-d');
            if ($contest[0]->expired_at >= $date) {
                $checkRecord = DB::select('SELECT SUM(task_count) as total FROM `contest_record` WHERE user_id=:uid and date(created_at) >=:dat', ['uid' => $uid, 'dat' => $contest[0]->start_from]);
                if (isset($checkRecord[0]->total)) {
                    if ($checkRecord[0]->total >= $contest[0]->task_require) {

                        $total = $user->balance + $contest[0]->coin;
                        $user->balance = $total;
                        $user->save();

                        //insert contest complete
                        DB::table('contest_completed')->insert(['user_id' => $uid, 'contest_id' => $id]);
                        $this->intTrans("Contest", $user->cust_id, $contest[0]->coin, $total, "Contest Completed");

                        return $this->respOk($contest[0]->coin . " Bonus Received", $total);
                        //addcontest
                    } else {
                        return $this->respError("Please Complete Contest Task and Submit Again");
                    }
                } else {
                    return $this->respError("Please Complete Contest Task and Submit Again");
                }
            } else {
                return $this->respError("Contest has been Ended");
            }
        } else {
            return $this->respError("Contest doesn't Exist");
        }
    }

    function validateDailyMission($uid, $mid)
    {
        $getMission = DB::table('daily_mission')->where('id', $mid)->select('title', 'coin', 'promo_coin', 'type')->get();
        if ($getMission) {

            $checkTodayStatus = DB::table('task')->where(['user_id' => $uid, 'task' => $getMission[0]->type])->whereDate('created_at', date('Y-m-d'))->count();
            if ($checkTodayStatus > 0) {
                return $this->respError("Today Bonus Already Claimed");
            }

            $user = Users::find($uid);
            $total = $user->balance + $getMission[0]->coin;
            if ($getMission[0]->promo_coin > 0) {
                $user->promo_balance = $user->promo_balance + $getMission[0]->promo_coin;
            }
            $user->save();

            DB::table('task')->insert(['user_id' => $uid, 'task' => $getMission[0]->type]);

            $this->intTrans("Daily Mission", $user->cust_id, $getMission[0]->coin, $total, $getMission[0]->title . " Mission Completed");

            return $this->respOk($getMission[0]->coin . " Bonus Received", $total);
        } else {
            return $this->respError("Invalid Mission Type");
        }
    }

    function creditVideo($user, $modelID)
    {
        if ($video = DB::table('youtube_video')->where('id', $modelID)->select('task_limit', 'point', 'views')->get()) {
            $limit = $this->getTaskLimit($user->subscription, 'task_video');
            $taskCount = $this->getTaskCount($user->cust_id, 'c_video');

            if ($taskCount > $limit) {
                return response()->json(['msg' => "Today Limit Completed For More Task Please Upgrade plan", 'code' => 202]);
            }

            if ($this->getTaskLog(2, $modelID, $user->cust_id) > 0) {
                return $this->respError("Bonus Already Received");
            }

            $c = $video[0]->point;
            $user->video += +1;
            $t = $user->balance + $c;
            $user->balance = $t;
            $user->save();
            DB::table('youtube_video')->where('id', $modelID)->update(['views' => ($video[0]->views + 1)]);
            if ($video[0]->task_limit > 0) {
                if (($video[0]->views + 1) >= $video[0]->task_limit) {
                    DB::table('youtube_video')->where('id', $modelID)->update(['status' => 1]);
                }
            }
            $this->updateTaskCount($user->cust_id, 'c_video', $taskCount + 1);
            $this->taskLog(2, $modelID, $user->cust_id);
            $this->intTrans("Video", $user->cust_id, $c, $t, $c . " Bonus Received");
            return $this->respOk($c . " Bonus Received", $t);
        } else {
            return $this->respError('Today No Task Left');
        }
    }

    function creditWeb($user, $modelID)
    {
        if ($web = DB::table('weblink')->where('id', $modelID)->select('task_limit', 'point', 'views')->get()) {
            $limit = $this->getTaskLimit($user->subscription, 'task_web');
            $taskCount = $this->getTaskCount($user->cust_id, 'c_web');

            if ($taskCount > $limit) {
                return response()->json(['msg' => "Today Limit Completed For More Task Please Upgrade plan", 'code' => 202]);
            }

            if ($this->getTaskLog(1, $modelID, $user->cust_id) > 0) {
                return $this->respError("Bonus Already Received");
            }

            $c = $web[0]->point;
            $t = $user->balance + $c;
            $user->balance = $t;
            $user->save();
            DB::table('weblink')->where('id', $modelID)->update(['views' => ($web[0]->views + 1)]);
            if ($web[0]->task_limit > 0) {
                if (($web[0]->views + 1) >= $web[0]->task_limit) {
                    DB::table('weblink')->where('id', $modelID)->update(['status' => 1]);
                }
            }
            $this->updateTaskCount($user->cust_id, 'c_web', $taskCount + 1);
            $this->taskLog(2, $modelID, $user->cust_id);
            $this->intTrans("Article", $user->cust_id, $c, $t, $c . " Bonus Received");
            return $this->respOk($c . " Bonus Received", $t);
        } else {
            return $this->respError('Today No Task Left');
        }
    }

    function creditPlayzone($user, $modelID)
    {
        $game = DB::table('games')->where('id', $modelID)->get();
        if ($game) {
            $cnt = Task::where(['type' => 3, 'user_id' => $user->cust_id, 'task_id' => $modelID])->whereDate('created_at', date('Y-m-d'))->count();

            if ($this->getTaskLog(3, $modelID, $user->cust_id) > 0) {
                return $this->respError("Bonus Already Received");
            }

            $c = $game[0]->game_coin;
            $t = $user->balance + $c;
            $user->balance = $t;
            $user->save();
            $this->taskLog(3, $modelID, $user->cust_id);
            $this->intTrans("Play Zone", $user->cust_id, $c, $t, $c . " Bonus Received");
            return $this->respOk($c . " Bonus Received", $t);
        } else {
            return $this->respError('Today No Task Left');
        }
    }

    function taskLog($type, $taskid, $uid)
    {
        Task::insert(['type' => $type, 'task_id' => $taskid, 'user_id' => $uid]);
    }

    function getTaskLog($type, $taskid, $uid)
    {
        return Task::where(['type' => $type, 'task_id' => $taskid, 'user_id' => $uid])->whereDate('created_at', date('Y-m-d'))->count();
    }

    function getLanguage()
    {
        return response(DB::table('app_lang')->where('status', 0)->orderBy('id', 'ASC')->get());
    }

    function dailycheck($user)
    {
        if ($this->getTaskCount($user->cust_id, 'c_dcheck') == date('Y-m-d')) {
            return $this->respError("Daily Bonus Already Claimed");
        } else {
            $data = DB::table('tbl_app_setting')->select('dailybonus')->get();
            $js = json_decode($data[0]->dailybonus, true);
            $day = Carbon::parse(Carbon::now())->format('l');
            if ($day == "Monday") {
                $coin = $js[0]['d1'];
            } else if ($day == "Tuesday") {
                $coin = $js[0]['d2'];
            } else if ($day == "Wednesday") {
                $coin = $js[0]['d3'];
            } else if ($day == "Thursday") {
                $coin = $js[0]['d4'];
            } else if ($day == "Friday") {
                $coin = $js[0]['d5'];
            } else if ($day == "Saturday") {
                $coin = $js[0]['d6'];
            } else if ($day == "Sunday") {
                $coin = $js[0]['d7'];
            }

            $this->updateTaskCount($user->cust_id, 'c_dcheck', date('Y-m-d'));
            $total = $user->balance + $coin;
            $user->balance = $total;
            $user->updated_at = $this->timestamp;
            $user->save();
            $this->intTrans("Daily Bonus", $user->cust_id, $coin, $total, $coin . " Bonus Received");
            return $this->respOk($coin . " Bonus Received", $total);
        }
    }

    function intTrans($task, $id, $coin, $total, $remark)
    {
        DB::table('transaction')->insert([
            'tran_type' => 'credit',
            'type' => $task,
            'user_id' => $id,
            'amount' => $coin,
            'ip' => Fun::IpAddr(),
            'remained_balance' => $total,
            'remarks' => $remark,
            'inserted_at' => Carbon::now()
        ]);
    }

    function respError($msg)
    {
        return response()->json(['msg' => $msg, 'code' => 404]);
    }

    function respOk($msg, $total)
    {
        return response()->json(['msg' => $msg, 'balance' => $total, 'code' => 201]);
    }

    public function funGame($game_type, $limit)
    {
        $data = DB::table('games')->where(['game_type' => $game_type])->orderBy('id', 'DESC')->limit(20)->get();
        return response()->json(['data' => $data, 'code' => 201]);
    }

    public function funOfferwalls($type)
    {
        $data = ($type != 'all') ? DB::table('offerwall')->where(['status' => 0, 'offer_type' => $type])->orderBy('row_order', 'ASC')->get() : DB::table('offerwall')->where('status', 0)->orderBy('row_order', 'ASC')->get();
        return response()->json(['data' => $data, 'code' => 201]);
    }

    public function funfaq($type)
    {
        $data = DB::table('faq')->where('type', $type)->orderBy('id', 'ASC')->get();
        return response()->json($data);
    }

    public function rewardCat()
    {
        $user = JWTAuth::User();
        $data = DB::table('redeem_cat')->select('id', 'name', 'image', 'country', 'min_coin', 'description')->where('country', 'LIKE', '%' . $user->country . '%')->orwhere(['country' => 'all', 'status' => 0])->where('status', '0')->orderBy('min_coin', 'ASC')->get();
        return response()->json($data);
    }

    public function funrewards($id)
    {
        $user = JWTAuth::User();
        $data = DB::select('select * from redeem where category=:cat and status=0 and country LIKE :cn or country =:all AND category=:cat1 ORDER by points + 0 ASC', ['cat' => $id, 'cn' => '%' . $user->country . '%', 'all' => 'all', 'cat1' => $id]);
        return response()->json(['data' => $data, 'code' => 201]);
    }

    public function funCoinstore()
    {
        $user = JWTAuth::User();
        $pay = DB::table('tbl_app_setting')->get()->first()->pay_info;
        $data = DB::table('coinstore')->where('status', '0')->where('country', 'LIKE', '%' . $user->country . '%')->orwhere('country', 'all')->get();
        return response()->json(['data' => $data, 'code' => 201, 'info' => $pay]);
    }

    public function isUserBanned()
    {
        if ($user = JWTAuth::User()) {
            if ($user->status == 1) {
                return response()->json(['msg' => $user->reason, 'code' => 401]);
            }
        } else {
            return response()->json(['msg' => 'Something went wrong', 'code' => 401]);
        }
    }

    public function IpAddr()
    {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if (isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if (isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if (isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }

    public function createPromo(Request $req)
    {
        if ($user = JWTAuth::User()) {
            $now = Carbon::now();
            $type = $req->type;
            $userid = $user->cust_id;

            $info = DB::table('tbl_app_setting')->where('id', 1)->select('video_promotecoin', 'promote_time', 'promo_videocoin', 'promo_webcoin', 'max_promote')->get();
            $userbal = $user->promo_balance;
            $promote = $req->limit;
            $maxpromote = $info[0]->max_promote;

            $coin = $info[0]->video_promotecoin;
            $debitCoint = $promote * $coin;
            $userBal = false;

            if (!($debitCoint <= $userbal)) {
                if ($userbal + $user->balance > ($debitCoint)) {
                    $userBal = true;
                } else {
                    return response()->json(['msg' => "Not Enough Coin", 'code' => 400]);
                }
            }

            if ($promote > $maxpromote) {
                return $this->respError('Max Promote Limit is' . $maxpromote);
            }


            if ($type == "video") {
                $tranType = 'Video Promotion';
                $remark = 'Video Promotion Created';

                $video = new Video;
                $video->title = $req->title;
                $video->thumb = $req->thumb;
                $video->timer = $info[0]->promote_time;
                $video->point = $info[0]->promo_videocoin;
                $video->task_limit = $promote;
                $video->type = "User";
                $video->userid = $userid;
                $video->status = 3;
                $video->url = $req->url;
                $res = $video->save();
            } else if ($type == "web") {

                $tranType = 'Website Promotion';
                $remark = 'Website Promotion Created';

                $weblink = new Web;
                $weblink->title = $req->title;
                $weblink->url = $req->url;
                $weblink->point = $info[0]->promo_webcoin;
                $weblink->timer = $info[0]->promote_time;
                $weblink->task_limit = $promote;
                $weblink->type = "User";
                $weblink->status = 3;
                $weblink->thumb = $req->thumb;
                $weblink->userid = $userid;
                $res = $weblink->save();
            }

            if ($userBal) {
                if ($user->promo_balance > 0) {
                    $left = $debitCoint - $user->promo_balance;
                    $user->promo_balance = 0;
                    $total = $user->balance - $left;
                    $user->balance = $total;

                    $trns = DB::table('transaction')
                        ->insert([
                            'tran_type' => 'debit',
                            'user_id' => $userid,
                            'amount' => $left,
                            'ip' => Fun::IpAddr(),
                            'type' => 'Promotion',
                            'remained_balance' => $total,
                            'inserted_at' => $now,
                            'remarks' => 'Coin Used for Promotion'
                        ]);
                } else {

                    $total = $user->balance - $debitCoint;
                    $user->balance = $total;
                    $trns = DB::table('transaction')
                        ->insert([
                            'tran_type' => 'debit',
                            'user_id' => $userid,
                            'amount' => $debitCoint,
                            'ip' => Fun::IpAddr(),
                            'type' => 'Promotion',
                            'remained_balance' => $total,
                            'inserted_at' => $now,
                            'remarks' => 'Coin Used for Promotion'
                        ]);
                }
            } else {
                $total = $userbal - $debitCoint;
                $user->promo_balance = $total;
            }

            $trns = DB::table('transaction')
                ->insert([
                    'tran_type' => 'debit',
                    'user_id' => $userid,
                    'amount' => $debitCoint,
                    'ip' => Fun::IpAddr(),
                    'type' => $tranType,
                    'remained_balance' => $total,
                    'inserted_at' => $now,
                    'remarks' => $remark
                ]);

            $user->save();

            if ($res && $trns) {
                return $this->respOk('Promotion Create Successfully', $total);
                return response()->json(['msg' => 'Promotion Create Successfully', 'total' => $total, 'userwallet' => $userBal, 'code' => 201]);
            } else {
                return $this->respError('Technical Error');
            }
        } else {
            return $this->respError("Something went wrong");
        }
    }

    public function cronjob($secret)
    {
        $db = DB::table('admin_key')->where('id', 1)->select('cron_secret', 'transaction_auto_delete')->get();
        $cronsec = $db[0]->cron_secret;
        $trans_delete = $db[0]->transaction_auto_delete;

        if ($secret == $cronsec) {
            DB::table('task_count')->update([
                'c_web' => 0,
                'c_video' => 0,
                'c_videozone' => 0,
                'c_quiz' => 0,
                'c_daily_offer' => 0,
                'c_spin' => 0,
                'c_scratch' => 0
            ]);

            DB::table('task')->delete();
            DB::table('appslog')->where('status', 1)->delete();

            $date = date('Y-m-d');
            $days = 7;
            DB::table('contest_task')->whereDate('created_at', '>', $date)->update(['status' => 2]);

            DB::table('global_msg')
                ->whereRaw('created_at < NOW() - INTERVAL ? DAY', [$days])
                ->delete();

            DB::table('password_reset')
                ->whereRaw('created_at < NOW() - INTERVAL ? DAY', [2])
                ->delete();

            DB::table('tbl_noti')
                ->whereRaw('created_at < NOW() - INTERVAL ? DAY', [7])
                ->delete();

            DB::table('transaction')
                ->whereRaw('inserted_at < NOW() - INTERVAL ? DAY', [$trans_delete])
                ->delete();

            $subexpire = DB::table('customer')->where('expired_at', '<', $date)->select('cust_id', 'subscription')->get();

            for ($i = 0; $i < count($subexpire); $i++) {
                $subinfo = DB::table('subscriptions')->where('id', $subexpire[$i]->subscription)->select('title')->get();

                DB::table('tbl_noti')->insert([
                    'user_id' => $subexpire[$i]->cust_id,
                    'title' => 'Subscription Expired',
                    'msg' => 'Subscription ' . $subinfo[0]->title . ' Expired. Renew to get Extra benefits.'
                ]);

                DB::table('global_msg')->insert([
                    'user_id' => $subexpire[$i]->cust_id,
                    'title' => 'Subscription Expired',
                    'msg' => 'Subscription ' . $subinfo[0]->title . ' Expired. Renew to get Extra benefits.',
                    'btn_name' => 'Upgrade',
                    'btn_action' => 'subscription',
                    'error' => 'true'
                ]);

                DB::table('customer')->where('cust_id', $subexpire[$i]->cust_id)->update(['subscription' => 1]);
            }


            $app = DB::table('tbl_app_setting')->where('id', 1)->select('daily_leaderboard1', 'daily_leaderboard2', 'daily_leaderboard3', 'weekly_leaderboard1', 'weekly_leaderboard2', 'weekly_leaderboard3')->get();


            $daily3 = DB::select("SELECT DISTINCT(user_id), SUM(amount) as balance,customer.name,customer.country,customer.profile FROM `transaction` left outer join customer on customer.cust_id=transaction.user_id WHERE transaction.tran_type='credit' and date(transaction.inserted_at)=:dat GROUP BY customer.name ORDER BY balance DESC LIMIT 3", ['dat' => date('Y-m-d')]);

            if (isset($daily3[0]->user_id)) {

                $u1 = Users::find($daily3[0]->user_id);
                $total = $u1->balance + $app[0]->daily_leaderboard1;
                $u1->balance = $total;
                $u1->save();

                DB::table('transaction')->insert([
                    'tran_type' => 'credit',
                    'type' => 'Leaderboard',
                    'user_id' => $daily3[0]->user_id,
                    'amount' => $app[0]->daily_leaderboard1,
                    'ip' => Fun::IpAddr(),
                    'remained_balance' => $total,
                    'remarks' => 'Daily Leaderboard Top 1 Winner',
                    'inserted_at' => Carbon::now()
                ]);

                DB::table('global_msg')->insert([
                    'user_id' => $daily3[0]->user_id,
                    'title' => 'Congratulations',
                    'msg' => 'You are on Daily Leaderboard Top 1 Winner.',
                    'btn_name' => 'close',
                    'btn_action' => 'close',
                    'error' => 'false'
                ]);
            }

            if (isset($daily3[1]->user_id)) {

                $u1 = Users::find($daily3[1]->user_id);
                $total = $u1->balance + $app[0]->daily_leaderboard2;
                $u1->balance = $total;
                $u1->save();

                DB::table('transaction')->insert([
                    'tran_type' => 'credit',
                    'type' => 'Leaderboard',
                    'user_id' => $daily3[1]->user_id,
                    'amount' => $app[0]->daily_leaderboard1,
                    'ip' => Fun::IpAddr(),
                    'remained_balance' => $total,
                    'remarks' => 'Daily Leaderboard Top 2 Winner',
                    'inserted_at' => Carbon::now()
                ]);

                DB::table('global_msg')->insert([
                    'user_id' => $daily3[1]->user_id,
                    'title' => 'Congratulations',
                    'msg' => 'You are on Daily Leaderboard Top 2 Winner.',
                    'btn_name' => 'close',
                    'btn_action' => 'close',
                    'error' => 'false'
                ]);
            }

            if (isset($daily3[2]->user_id)) {

                $u1 = Users::find($daily3[2]->user_id);
                $total = $u1->balance + $app[0]->daily_leaderboard2;
                $u1->balance = $total;
                $u1->save();

                DB::table('transaction')->insert([
                    'tran_type' => 'credit',
                    'type' => 'Leaderboard',
                    'user_id' => $daily3[2]->user_id,
                    'amount' => $app[0]->daily_leaderboard1,
                    'ip' => Fun::IpAddr(),
                    'remained_balance' => $total,
                    'remarks' => 'Daily Leaderboard Top 3 Winner',
                    'inserted_at' => Carbon::now()
                ]);

                DB::table('global_msg')->insert([
                    'user_id' => $daily3[2]->user_id,
                    'title' => 'Congratulations',
                    'msg' => 'You are on Daily Leaderboard Top 3 Winner.',
                    'btn_name' => 'close',
                    'btn_action' => 'close',
                    'error' => 'false'
                ]);
            }


            $day = Carbon::parse(Carbon::now())->format('l');
            if ($day == "Monday") {
                $weekly = DB::select("SELECT DISTINCT(user_id), SUM(amount) as balance,customer.name,customer.country,customer.profile FROM transaction left outer join customer on customer.cust_id=transaction.user_id WHERE transaction.tran_type='credit' and date(transaction.inserted_at)>=:start AND date(transaction.inserted_at) <=:end GROUP BY user_id ORDER BY balance DESC LIMIT 3", ['start' => date('Y-m-d', strtotime("this week")), 'end' => date('Y-m-d', strtotime("sunday this week", strtotime($date)))]);


                if (isset($weekly[0]->user_id)) {

                    $u1 = Users::find($weekly[0]->user_id);
                    $total = $u1->balance + $app[0]->weekly_leaderboard1;
                    $u1->balance = $total;
                    $u1->save();

                    DB::table('transaction')->insert([
                        'tran_type' => 'credit',
                        'type' => 'Leaderboard',
                        'user_id' => $weekly[0]->user_id,
                        'amount' => $app[0]->weekly_leaderboard1,
                        'ip' => Fun::IpAddr(),
                        'remained_balance' => $total,
                        'remarks' => 'Weekly Leaderboard Top 1 Winner',
                        'inserted_at' => Carbon::now()
                    ]);

                    DB::table('global_msg')->insert([
                        'user_id' => $daily3[0]->user_id,
                        'title' => 'Congratulations',
                        'msg' => 'You are on Weekly Leaderboard Top 1 Winner.',
                        'btn_name' => 'close',
                        'btn_action' => 'close',
                        'error' => 'false'
                    ]);
                }

                if (isset($weekly[1]->user_id)) {

                    $u1 = Users::find($weekly[1]->user_id);
                    $total = $u1->balance + $app[0]->weekly_leaderboard2;
                    $u1->balance = $total;
                    $u1->save();

                    DB::table('transaction')->insert([
                        'tran_type' => 'credit',
                        'type' => 'Leaderboard',
                        'user_id' => $weekly[1]->user_id,
                        'amount' => $app[0]->weekly_leaderboard2,
                        'ip' => Fun::IpAddr(),
                        'remained_balance' => $total,
                        'remarks' => 'Weekly Leaderboard Top 2 Winner',
                        'inserted_at' => Carbon::now()
                    ]);

                    DB::table('global_msg')->insert([
                        'user_id' => $weekly[1]->user_id,
                        'title' => 'Congratulations',
                        'msg' => 'You are on Weekly Leaderboard Top 2 Winner.',
                        'btn_name' => 'close',
                        'btn_action' => 'close',
                        'error' => 'false'
                    ]);
                }

                if (isset($weekly[2]->user_id)) {

                    $u1 = Users::find($weekly[2]->user_id);
                    $total = $u1->balance + $app[0]->weekly_leaderboard3;
                    $u1->balance = $total;
                    $u1->save();

                    DB::table('transaction')->insert([
                        'tran_type' => 'credit',
                        'type' => 'Leaderboard',
                        'user_id' => $weekly[2]->user_id,
                        'amount' => $app[0]->weekly_leaderboard3,
                        'ip' => Fun::IpAddr(),
                        'remained_balance' => $total,
                        'remarks' => 'Weekly Leaderboard Top 3 Winner',
                        'inserted_at' => Carbon::now()
                    ]);

                    DB::table('global_msg')->insert([
                        'user_id' => $weekly[2]->user_id,
                        'title' => 'Congratulations',
                        'msg' => 'You are on Weekly Leaderboard Top 3 Winner.',
                        'btn_name' => 'close',
                        'btn_action' => 'close',
                        'error' => 'false'
                    ]);
                }
            }

            \Artisan::call('view:clear');
            \Artisan::call('cache:clear');
            \Artisan::call('route:clear');
            \Artisan::call('config:clear');

            return response()->json(['msg' => 'Cron Job Run Successfully!!.']);
        } else {
            return 'Cron Key Not match';
        }
    }

    function addDayinDate($day)
    {
        return Date('Y-m-d', strtotime('+' . $day . ' days'));
    }

    public function moveTaskPending($userid, $appid)
    {
        $d = DB::table('appslog')->where(['user_id' => $userid, 'appid' => $appid])->count();
        if ($d) {
            return $this->respError("offer Already in Pending");
        } else {
            DB::table('appslog')->insert([
                'user_id' => $userid,
                'appid' => $appid,
                'status' => 1,
                'created_at' => date('Y-m-d')
            ]);

            return response()->json(['msg' => 'Offer added in pending', 'code' => 201]);
        }
    }

    function YouTubeGetID($url)
    {
        if (stristr($url, 'youtu.be/')) {
            preg_match('/(https:|http:|)(\/\/www\.|\/\/|)(.*?)\/(.{11})/i', $url, $final_ID);
            return $final_ID[4];
        } else {
            @preg_match('/(https:|http:|):(\/\/www\.|\/\/|)(.*?)\/(embed\/|watch.*?v=|)([a-z_A-Z0-9\-]{11})/i', $url, $IDD);
            return $IDD[5];
        }
    }

    public function notiMsg($id)
    {
        $data = DB::table('tbl_noti')->where(['user_id' => $id, 'noti_type' => 0])->orWhere(['user_id' => 0, 'noti_type' => 1])->select('title', 'msg', 'created_at')->latest()->limit(30)->get();
        return response()->json($data);
    }

    public function getGlobalMsg($id)
    {
        $data = DB::table('global_msg')->where(['user_id' => $id, 'status' => 0])->orWhere(['user_id' => 0])->inRandomOrder()->limit(1)->get();
        return response()->json($data);
    }

    function readnoti()
    {
        if ($user = JWTAuth::User()) {
            DB::table('tbl_noti')->where(['user_id' => $user->cust_id])->update(['status' => 1]);
            return response()->json(['msg' => "Notificatin Mark as Read", 'balance' => 0, 'code' => 201]);
        }
    }

    public function submit_dailyoffer(Request $req)
    {
        if ($user = JWTAuth::User()) {

            $cn = DB::table('data_dailyoffer')->where(['survey_id' => $req->id, 'user_id' => $user->cust_id])->count();

            if ($cn > 0) {
                return response()->json(['msg' => 'Offer Already Submited', 'code' => 201]);
            }

            $image = $req->newimage;
            $filenameWithExt = $image->getClientOriginalName();
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $filename = preg_replace("/[^A-Za-z0-9 ]/", '', $filename);
            $filename = preg_replace("/\s+/", '-', $filename);
            $extension = $image->getClientOriginalExtension();
            $fileNameToStore = uniqid() . '_' . time() . '.' . $extension;
            $image_resize = Image::make($image->getRealPath());
            $image_resize->resize(300, 500);
            $image_resize->save('images/dailyoffer/' . $fileNameToStore);

            DB::table('data_dailyoffer')->insert([
                'url' => $req->link,
                'survey_id' => $req->id,
                'taskStatus' => 0,
                'image' => $fileNameToStore,
                'user_id' => $user->cust_id,
                'name' => $user->name,
                'email' => $user->email
            ]);

            $srv = DB::table('tbl_dailyoffer')->where('id',  $req->id)->get();

            DB::table('tbl_dailyoffer')->where('id',  $req->id)->update(['views' => ($srv[0]->views + 1)]);

            if ($srv[0]->task_limit > 0) {
                if (($srv[0]->views + 1)  >= $srv[0]->task_limit) {
                    DB::table('tbl_dailyoffer')->where('id',  $req->id)->update(['status' => 1]);
                }
            }

            return response()->json(['msg' => 'Offer Submit Successfully Bonus will be receive after verification', 'code' => 201]);
        }
    }

    public function AddPaymentProof(Request $req)
    {
        if ($user = JWTAuth::User()) {

            $modelId = $req->model_id;

            if ($req->model_type == "sub") {
                $modelType = 1;
            } else if ($req->model_type == "coinstore" || $req->model_type == "coin") {
                $modelType = 0;
            }

            $cn = DB::table('payment_proof')->where(['model_type' => $req->model_type, 'user_id' => $user->cust_id])->where('status', '!=', 0)->count();

            if ($cn > 0) {
                return response()->json(['msg' => 'Payment Details Already Submitted it will be Update in 24 Hours', 'code' => 401]);
            }

            if ($modelType == "1") {
                $db = DB::table('subscriptions')->where('id', $modelId)->select('currency', 'amount', 'title', 'valid_for', 'currency_posi')->get();
                $modalinfo = $db[0]->title . ' | ' . (($db[0]->currency_posi == 0) ? $db[0]->currency . ' ' . $db[0]->amount : $db[0]->amount . ' ' . $db[0]->currency) . ' | ' . $db[0]->valid_for . ' Month';
            } else if ($modelType == "0") {
                $db = DB::table('coinstore')->where('id', $modelId)->select('currency', 'amount', 'title', 'coin', 'currency_posi')->get();
                $modalinfo = $db[0]->title . ' | ' . (($db[0]->currency_posi == 0) ? $db[0]->currency . ' ' . $db[0]->amount : $db[0]->amount . ' ' . $db[0]->currency) . ' | ' .  $db[0]->coin . ' Coin';
            }


            if ($req->newimage) {
                $image = $req->newimage;
                $filenameWithExt = $image->getClientOriginalName();
                $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                $filename = preg_replace("/[^A-Za-z0-9 ]/", '', $filename);
                $filename = preg_replace("/\s+/", '-', $filename);
                $extension = $image->getClientOriginalExtension();
                $fileNameToStore = uniqid() . '_' . time() . '.' . $extension;
                $image_resize = Image::make($image->getRealPath());
                $image_resize->resize(300, 500);
                $image_resize->save('images/payment/' . $fileNameToStore);


                DB::table('payment_proof')->insert([
                    'model_type' => $modelType,
                    'modal_info' => $modalinfo,
                    'transaction_id' => $req->trans_id,
                    'image' => $fileNameToStore,
                    'model_id' => $req->model_id,
                    'payment_modal' => $req->type,
                    'payment_modal_id' => $req->id,
                    'user_id' => $user->cust_id
                ]);

                return response()->json(['msg' => 'Payment Request Submit Successfully Bonus will be receive in 24 hours after verification', 'code' => 201]);
            } else {
                return response()->json(['msg' => 'Please Select Valid Payment Success Screenshot', 'code' => 401]);
            }
        }
    }

    //let update
    public function verifyPay(Request $request)
    {
        if ($user = JWTAuth::User()) {
            if ($json = MyAuth::Validation($request->data)) {
                $req = json_decode(base64_decode($json), true);

                $patwith = $req['paywith'];
                $modelID = $req['model_id'];
                $modelType = $req['model_type'];
                $orderId = $req['orderid'];
                $status = $req['status'];

                $validator = Validator::make($req, [
                    'paywith' => 'required',
                    'model_id' => 'required',
                    'model_type' => 'required',
                    'status' => 'required',
                ]);

                if ($validator->fails()) {
                    return response()->json(['message' => "Something went wrong", 'code' => 401]);
                }

                if ($modelType == "sub") {

                    if ($subs = _Subscriptions::find($modelId)) {

                        $modalinfo =  $subs->title . ' | ' . (($sub->currency_posi == 0) ? $subs->currency . ' ' . $subs->amount : $subs->amount . ' ' . $subs->currency) . ' | ' . $subs->valid_for . ' Month';

                        $day = $subs->valid_for * 30;
                        $currentTime = Carbon::now();
                        $expiredAt = Date('Y-m-d', strtotime('+' . $day . ' days'));

                        $promo = false;
                        $total = 0;
                        if ($subs->promo_coin > 0) {
                            $promo = true;
                            $oldcoin = $user->promo_balance;
                            $total = $oldcoin + $subs->promo_coin;
                            $user->promo_balance = $total;
                        }

                        // updating user
                        $user->purchased_at = $currentTime;
                        $user->expired_at = $expiredAt;
                        $user->subscription = $subid;
                        $user->expire_sub = $subid;
                        $user->save();

                        //insertsub
                        $insertRecord = DB::table('subscribed_user')->insert([
                            'user_id' => $user->cust_id,
                            'sub_id' => $subid,
                            'validity' => $subs->valid_for,
                            'days' => $day,
                            'subscribed_at' => $currentTime,
                            'expired_at' => $expiredAt,
                            'amount' => $subs->amount,
                            'sub_info' => $modalinfo,
                            'payment_mode' => $patwith,
                            'remark' => $patwith . 'Mode'
                        ]);

                        DB::table('payment_transaction')->insert([
                            'userid' => $user->cust_id,
                            'method' => $patwith,
                            'trans_id' => $orderId,
                            'amount' => ($sub->currency_posi == 0) ? $subs->currency . ' ' . $subs->amount : $subs->amount . ' ' . $subs->currency,
                            'status' => $status,
                            'model_id' => $modelID,
                            'type' => 1,
                            'pacinfo' => $modalinfo
                        ]);

                        DB::table('transaction')->insert([
                            'tran_type' => 'credit',
                            'type' => 'Subscription',
                            'ip' => Fun::IpAddr(),
                            'user_id' =>  $user->cust_id,
                            'remained_balance' => $total,
                            'remarks' => 'Subscription Purchased'
                        ]);

                        if ($promo) {
                            DB::table('transaction')
                                ->insert([
                                    'tran_type' => 'credit',
                                    'user_id' => $req->id,
                                    'amount' => $subs->promo_coin,
                                    'type' => 'Promo Coin',
                                    'remained_balance' => $total,
                                    'inserted_at' => Carbon::now(),
                                    'remarks' => 'Subscription Promo Coin Credit'
                                ]);
                        }

                        return $this->respOk("Congratulation your are now " . $subs->title . " Member.", $total);
                    } else {
                        return $this->respError("Subscription doesn't exist.");
                    }
                } else if ($modelType == "coinstore" || $modelType == "coin") {
                    $pc = DB::table('coinstore')->where('id', $modelID)->get();
                    $modalinfo = $pc[0]->title . ' | ' . (($pc[0]->currency_posi == 0) ? $pc[0]->currency . ' ' . $pc[0]->amount : $pc[0]->amount . ' ' . $pc[0]->currency) . ' | ' .  $pc[0]->coin . ' Coin';

                    if ($pc) {

                        DB::table('payment_transaction')->insert([
                            'userid' => $user->cust_id,
                            'method' => $patwith,
                            'trans_id' => $orderId,
                            'amount' => ($pc[0]->currency_posi == 0) ? $pc[0]->currency . ' ' . $pc[0]->amount : $pc[0]->amount . ' ' . $pc[0]->currency,
                            'status' => $status,
                            'model_id' => $modelID,
                            'type' => 0,
                            'pacinfo' => $modalinfo
                        ]);

                        $total = $user->promo_balance + $pc[0]->coin;
                        $user->promo_balance = $total;

                        DB::table('transaction')->insert([
                            'tran_type' => 'credit',
                            'type' => 'Coin',
                            'ip' => Fun::IpAddr(),
                            'user_id' =>  $user->cust_id,
                            'amount' => $pc[0]->coin,
                            'remained_balance' => $total,
                            'remarks' => 'Coin Purchased'
                        ]);

                        DB::table('tbl_noti')->insert(['user_id' => $user->cust_id, 'title' => "Coin Purchase", 'msg' => "Coin Purchase Successfully. added to your wallet", 'created_at' => Carbon::now()]);
                        $data = $user->save();

                        if ($data) {
                            return $this->respOk("Promo Coin Purchase Successfully.", $total);
                        } else {
                            return $this->respError("Server Error.");
                        }
                    }
                }
            }
        }
    }

    public function supportTicket()
    {
        if ($user = JWTAuth::User()) {
            $data = DB::table('support_ticket')->where('user_id', $user->cust_id)->latest()->get();
            return response()->json($data);
        }
    }

    public function createSupportTicket(Request $req)
    {
        if ($user = JWTAuth::User()) {
            $cnt = DB::table('support_ticket')->where('user_id', $user->cust_id)->where('status', '<', 2)->count();
            if ($cnt > 0) {
                return $this->respError("You have already one Active Support Ticket.");
            }

            $ins = DB::table('support_ticket')->insert([
                'user_id' => $user->cust_id,
                'ticketID' => mt_rand(123456, 999999),
                'email' => $req->email,
                'name' => $user->name,
                'subject' => $req->subject,
                'message' => $req->message,
                'status' => 0,
                'created_at' => Carbon::now()
            ]);

            if ($ins) {
                return $this->respOk("Ticket Created Successfully. Reponse will be with in 48 hours.", 0);
            } else {
                return $this->respError("Something went wrong");
            }
        }
    }

    function getReferralHistory()
    {
        if ($user = JWTAuth::User()) {
            $data = DB::table('customer')->join('subscriptions', 'subscriptions.id', '=', 'customer.subscription')
                ->select('customer.name', 'customer.profile', 'customer.balance', 'customer.country', 'customer.subscription', 'customer.inserted_at', 'customer.cust_id', 'customer.refer', 'subscriptions.image')
                ->where('customer.from_refferal_id', $user->refferal_id)
                ->orderBy('cust_id', 'DESC')->limit(30)->get();

            return response(['data' => $data]);
        }
    }

    function deleteAccount()
    {
        if ($user = JWTAuth::User()) {
            /*   $id = $user->cust_id;
            DB::table('customer')->where('cust_id', $id)->delete();
            DB::table('transaction')->where('user_id', $id)->delete();
            DB::table('recharge_request')->where('user_id', $id)->delete();
            DB::table('appslog')->where('user_id', $id)->delete();
            DB::table('data_dailyoffer')->where('user_id', $id)->delete();
            DB::table('monitor_report')->where('userid', $id)->delete();
*/
            return $this->respOk("Account Deleted Service Currently Not Available", 0);
        } else {
            return $this->respError("Session Expired Login Again");
        }
    }
}
