<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\TaskCount;
use App\Models\Users;
use App\Models\_Subscriptions;
use Validator;
use Illuminate\Support\Facades\Hash;
use JWTAuth, DB, GeoIP;
use Tymon\JWTAuth\Exceptions\JWTException;
use Carbon\Carbon;
use Mail;
use App\Mail\NotifyMail;
use App\Http\Controllers\Api\MyAuth;
use Illuminate\Mail\SentMessage;

class UserAuth extends Controller
{
    /**
     * Create a new AuthController instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth:api', ['except' => ['login', 'signup', 'reset_password', 'verify_otp', 'update_password']]);
        $this->guard = "api";
    }

    /**
     * Get a JWT via given credentials.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function login(Request $request)
    {

        if ($json = MyAuth::Validation($request->data)) {
            $req = json_decode(base64_decode($json), true);

            if ($info = MyAuth::Validation($request->secure)) {
                $secure = json_decode(base64_decode($info), true);
            } else {

                return response()->json([
                    'code' => 404,
                    'message' => 'Invalid User Please Contact to Admin.',
                ]);
            }
                       

            if ($req['type'] == "google") {

                $validator = Validator::make($req, [
                    'email' => 'required|email',
                    'person_id' => 'required|string|min:5',
                ]);
            } else {

                $validator = Validator::make($req, [
                    'email' => 'required|email',
                    'password' => 'required|string|min:5',
                ]);
            }


            if ($validator->fails()) {
              //  return response()->json(['message' => $validator->errors()->first(), 'code' => 401]);
                return response()->json(['message' => "Something went wrong", 'code' => 401]);
            }

            if ($req['type'] == "google") {
                $user = Users::where(['email' => $req['email'], 'person_id' => $req['person_id']])->first();
            } else {
                $user = Users::where('email',$req['email'])->first();
            }

            if ($user) {
                
                if($req['type'] != "google"){
                    if (!Hash::check($req['password'], $user->password)) {
                        return response()->json([
                                'code' => 404,
                                'message' => 'Login credentials are invalid!.',
                            ]);
                    }
                }
                
                $task = TaskCount::where('user_id', $user->cust_id)->first();
                if (is_null($task)) {
                    DB::table('task_count')->insert(['user_id' => $user->cust_id]);
                }

                try {
                    /* if (!Hash::check($req['password'], $user->password)) {
                        return response()->json([
                            'code' => 404,
                            'message' => 'Login credentials are invalid!.',
                        ]);
                    }*/

                    if (!$token = JWTAuth::fromUser($user)) {

                        return response()->json([
                            'code' => 404,
                            'message' => 'Login credentials are invalid.',
                        ]);
                    }
                } catch (JWTException $e) {
                    return $credentials;
                    return response()->json([
                        'code' => 404,
                        'message' => 'Could not create token.'
                    ]);
                }
            } else {
                return response()->json([
                    'code' => 404,
                    'message' => 'Account Not Exist!!.',
                ]);
            }

            $prevention = DB::table('fraud_prevention')->where('id', 1)->get();

            if ($secure['clone'] == 'true' && $prevention[0]->app_clonning == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Clone App.', 'code' => 401]);
            }

            if ($secure['emu'] == 'true' && $prevention[0]->block_emulator == 'true') {
                $this->logmonitor($user->cust_id, "Emulator Device Used.");
                return response()->json(['message' => 'Security Reason You Cant Use App on Emulator.', 'code' => 401]);
            }

            if ($secure['termux'] == 'true' && $prevention[0]->block_termux == 'true') {
                return response()->json(['message' => 'Termux App Detected!! Uninstall to Use App', 'code' => 401]);
            }

            if ($secure['devMode'] == 'false' && $prevention[0]->block_devMode == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Use App on Developer Mode On.', 'code' => 401]);
            }
            
          
            if ($prevention[0]->vpn_required == 'true') {
                if ($secure['vpn'] == false || $secure['vpn'] == ''){
                    return response()->json(['message' => $prevention[0]->vpn_required_msg, 'code' => 401]);
                }
            }
                
            if ($secure['vpn'] == 'true') {

                if ($prevention[0]->auto_banVpn == 'true') {
                    $this->logmonitor($user->cust_id, "VPN Used.");
                    $this->banuser($user->cust_id, "Account Banned for Security Reason VPN Used.");
                    return response()->json(['message' => 'Account Banned for Security Reason VPN Used.', 'code' => 401]);
                }

                if ($prevention[0]->block_vpn == 'true') {
                    return response()->json(['message' => 'Security Reason You Cant Use App with VPN.', 'code' => 401]);
                }

                if ($prevention[0]->vpn_monitor == 'true') {
                    $this->logmonitor($user->cust_id, "VPN Used.");
                }
            }

            if ($secure['root'] == 'true') {
                $this->logmonitor($user->cust_id, "Root Device.");

                if ($prevention[0]->auto_banroot == 'true') {
                    $this->banuser($user->cust_id, "Account Banned for Security Reason Rooted Device.");
                    return response()->json(['message' => 'Account Banned for Security Reason Used Rooted Device.', 'code' => 401]);
                }

                if ($prevention[0]->block_root_device == 'true') {
                    return response()->json(['message' => 'Security Reason You Cant Use App on Rooted Device.', 'code' => 401]);
                }
            }


            if ($user->status == 1) {
                return response()->json(['message' => $user->reason, 'code' => 401]);
            }

            if ($user->updated_at != date('Y-m-d')) {
                Users::where('cust_id', $user->cust_id)->update(['updated_at' => date('Y-m-d')]);
            }

            // Get the token
            return $this->createNewTokenGoogle($user, $token);
        }

        return response()->json([
            'code' => 404,
            'message' => 'Invalid User Please Contact to Admin.',
        ]);
    }


    public function signup(Request $request)
    {
        if ($json = MyAuth::Validation($request->data)) {
            $req = json_decode(base64_decode($json), true);

            if ($info = MyAuth::Validation($request->secure)) {
                $secure = json_decode(base64_decode($info), true);
            } else {

                return response()->json([
                    'code' => 404,
                    'message' => 'Invalid User Please Contact to Admin.',
                ]);
            }

            if ($req['type'] == "google") {
                return $this->Googleregister($req, $secure);
            }

            $validator = Validator::make($req, [
                'name' => 'required|string|between:4,15|regex:/^[\w ]+$/|unique:customer',
                'email' => 'required|string|email|max:40|unique:customer',
                'password' => 'required|string|min:6'
            ]);

            if ($validator->fails()) {
                return response()->json(['message' => $validator->errors()->first(), 'code' => 401]);
            }

            geoip()->getLocation(null);
            $ip = UserAuth::getUserIpAddr();
            $arr_ip = geoip()->getLocation($ip);

            $prevention = DB::table('fraud_prevention')->where('id', 1)->get();

            if ($prevention[0]->block_country == 'true' && $prevention[0]->block_country_iso != null) {
                $iso = $prevention[0]->block_country_iso;
                $ar = explode(",", $iso);
                if (in_array($arr_ip->iso_code, $ar)) {
                    return response()->json(['message' => $prevention[0]->block_country_msg, 'code' => 401]);
                }
            }


            $cdip = Users::where('ip', $ip)->count();
            if ($cdip >= $prevention[0]->oneip_device) {
                return response()->json(['message' => 'Account Create Limit Reached.', 'code' => 401]);
            }

            if ($prevention[0]->onedevice == 'true') {
                if ($cd = Users::where('token', $secure['token'])->select('email')->first()) {
                    return response()->json(['message' => 'Account Already Exist ' . $cd->email, 'code' => 401]);
                }
            }

            if ($secure['clone'] == 'true' && $prevention[0]->app_clonning == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Clone App.', 'code' => 401]);
            }

            if ($secure['emu'] == 'true' && $prevention[0]->block_emulator == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Use App on Emulator.', 'code' => 401]);
            }

            if ($secure['termux'] == 'true' && $prevention[0]->block_termux == 'true') {
                return response()->json(['message' => 'Termux App Detected!! Uninstall to Use App', 'code' => 401]);
            }

           if ($secure['devMode'] == 'false' && $prevention[0]->block_devMode == 'true') {
            return response()->json(['message' => 'Security Reason You Cant Use App on Developer Mode On.', 'code' => 401]);
            }

            if ($secure['root'] == 'true' && $prevention[0]->block_root_device == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Use App on Rooted Device.', 'code' => 401]);
            }
            
            $refer=false;
            $refid="";
            if($secure['ref']!=null){
                if ($checkRef = Users::where('refferal_id', $secure['ref'])->first()) {
                    $refid=$secure['ref'];
                   $refer=true; 
                }
            }


            $user               =       new Users;
            $user->name         =       $req['name'];
            $user->email        =       $req['email'];
            $user->token        =       $secure['token'];
            $user->p_token      =       $req['p_token'];
            $user->password     =       Hash::make($req['password']);
            $user->type         =       "email";
            $user->refferal_id  =       UserAuth::genUserCode();
            $user->ip           =       $ip;
            $user->country      =       $arr_ip->iso_code;
            $res_user = $user->save();
            
            DB::table('task_count')->insert(['user_id' => $user->cust_id]);
             
            if($refer){
                $user=Users::find($user->cust_id);
                $setting = DB::table('tbl_app_setting')->where('id', 1)->select('welcome_bonus', 'refer_mode')->get();
                $bonus = $setting[0]->welcome_bonus;
            
                $wb = explode('-', $setting[0]->welcome_bonus);
    
                if ($setting[0]->refer_mode == "direct") {
                    $coin = $wb[1];
                } else {
                    $coin = $wb[1] / 2;
                }
    
                $coin = rand($wb[0], $coin);
                
                $user->from_refferal_id = $refid;
                if ($setting[0]->refer_mode == "direct") {
                    $sub = _Subscriptions::where('id', $checkRef->subscription)->select('refer_bonus')->get();
                    $exp = explode("-", $sub[0]->refer_bonus);
                    $fromcoin = rand($exp[0], $exp[1]);

                    DB::table('scratch_card')->insert([
                        'user_id' => $checkRef->cust_id,
                        'coin' => $fromcoin,
                        'remark' => 'Referral Bonus Credit From ' . $checkRef->name
                    ]);
                    
                    if($crnt=DB::table('contest_record')->where('user_id',$checkRef->cust_id)->whereDate('created_at',date('Y-m-d'))->first()){
                          DB::table('contest_record')->where('id',$crnt->id)->update([
                                        'user_id' =>$checkRef->cust_id,
                                        'to_user_id' =>$user->cust_id,
                                        'task_count' =>($crnt->task_count+1),
                                    ]);
                      }else{
                            DB::table('contest_record')->insert([
                                        'user_id' =>$checkRef->cust_id,
                                        'to_user_id' => '1',
                                        'task_count' =>1,
                                    ]);
                        }

                    DB::table('global_msg')->insert([
                        'user_id' => $checkRef->cust_id,
                        'title' => 'Congratulations',
                        'msg' => 'You Won Scratch Card for Invite your friend ' . $checkRef->name,
                        'btn_name' => 'Open Scratch Card',
                        'btn_action' => 'invite',
                        'error' => 'false'
                    ]);

                    $user->refer = true;
                  DB::table('scratch_card')->insert(['user_id' => $user->cust_id, 'coin' => $coin, 'remark' => 'Welcome Bonus']);

                }
                else{
                    
                    $exp = explode("-", $sub[0]->welcome_bonus);
                    $fromcoin = rand($exp[0], $exp[1]);
                    
                    DB::table('global_msg')->insert([
                        'user_id' => $user->cust_id,
                        'title' => 'Congratulations',
                        'msg' => 'You Won Scratch Card from your Friend ' . $checkRef->name,
                        'btn_name' => 'Open Scratch Card',
                        'btn_action' => 'invite',
                        'error' => 'false'
                    ]);

                    $user->refer = true;
                    DB::table('scratch_card')->insert(['user_id' => $user->cust_id, 'coin' => $coin, 'remark' => 'Welcome Bonus Part 1']);

                }
                $user->save();
            }


            return response()->json([
                'message' => 'Account Created Successfully Click to Login Now', 'code' => 201
            ]);
        }

        return response()->json([
            'code' => 404,
            'message' => 'Invalid User Please Contact to Admin.',
        ]);
    }

    public function googlelogin($req, $secure)
    {
        $validator = Validator::make($req, [
            'email' => 'required|string|email|max:100',
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => $validator->errors()->first(), 'code' => 401]);
        }
        $user = Users::where(['person_id' => $req['person_id'], 'email' => $req['email']])->first();

        if ($user) {

            $task = TaskCount::where('user_id', $user->cust_id)->first();
            if (is_null($task)) {
                DB::table('task_count')->insert(['user_id' => $user->cust_id]);
            }

            try {
                if (!$token = JWTAuth::fromUser($user)) {
                    return response()->json([
                        'code' => 401,
                        'message' => 'Login credentials are invalid.',
                    ]);
                }
            } catch (JWTException $e) {
                return $credentials;
                return response()->json([
                    'code' => 401,
                    'message' => 'Could not create.',
                ]);
            }

            $prevention = DB::table('fraud_prevention')->where('id', 1)->get();

            if ($secure['clone'] == 'true' && $prevention[0]->app_clonning == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Clone App.', 'code' => 401]);
            }

            if ($secure['emu'] == 'true' && $prevention[0]->block_emulator == 'true') {
                $this->logmonitor($user->cust_id, "Emulator Device Used.");
                return response()->json(['message' => 'Security Reason You Cant Use App on Emulator.', 'code' => 401]);
            }

            if ($secure['termux'] == 'true' && $prevention[0]->block_termux == 'true') {
                return response()->json(['message' => 'Termux App Detected!! Uninstall to Use App', 'code' => 401]);
            }

            if ($secure['devMode'] == 'false' && $prevention[0]->block_devMode == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Use App on Developer Mode On.', 'code' => 401]);
            }
            
            if ($prevention[0]->vpn_required == 'true') {
                if ($secure['vpn'] == false){
                    return response()->json(['message' => $prevention[0]->vpn_required_msg, 'code' => 401]);
                }
            }

            if ($secure['vpn'] == 'true') {

                if ($prevention[0]->auto_banVpn == 'true') {
                    $this->logmonitor($user->cust_id, "VPN Used.");
                    $this->banuser($user->cust_id, "Account Banned for Security Reason VPN Used.");
                    return response()->json(['message' => 'Account Banned for Security Reason VPN Used.', 'code' => 401]);
                }

                if ($prevention[0]->block_vpn == 'true') {
                    return response()->json(['message' => 'Security Reason You Cant Use App with VPN.', 'code' => 401]);
                }

                if ($prevention[0]->vpn_monitor == 'true') {
                    $this->logmonitor($user->cust_id, "VPN Used.");
                }
            }

            if ($secure['root'] == 'true') {
                $this->logmonitor($user->cust_id, "Root Device.");

                if ($prevention[0]->auto_banroot == 'true') {
                    $this->banuser($user->cust_id, "Account Banned for Security Reason Rooted Device.");
                    return response()->json(['message' => 'Account Banned for Security Reason Used Rooted Device.', 'code' => 401]);
                }

                if ($prevention[0]->block_root_device == 'true') {
                    return response()->json(['message' => 'Security Reason You Cant Use App on Rooted Device.', 'code' => 401]);
                }
            }

            if ($user->status == 1) {
                return response()->json(['message' => $user->reason, 'code' => 401]);
            }
            if ($user->updated_at != date('Y-m-d')) {
                Users::where('cust_id', $user->cust_id)->update(['updated_at' => Carbon::now()]);
            }

            return $this->createNewTokenGoogle($user, $token);
        } else {
            return response()->json([
                'code' => 401,
                'message' => 'Login credentials are invalid.',
            ]);
        }
    }

    public function Googleregister($req, $secure)
    {
        $validator = Validator::make($req, [
            'email' => 'required|string|email|max:100|unique:users',
        ]);


        if ($validator->fails()) {
            return response()->json(['message' => $validator->errors()->first(), 'code' => 401]);
        }
        if ($user = Users::where(['person_id' => $req['person_id'], 'email' => $req['email']])->first()) {

            try {
                if (!$token = JWTAuth::fromUser($user)) {
                    return response()->json([
                        'code' => 401,
                        'message' => 'Login credentials are invalid.',
                    ]);
                }
            } catch (JWTException $e) {
                return $credentials;
                return response()->json([
                    'code' => 401,
                    'message' => 'Could not create.',
                ]);
            }


            $prevention = DB::table('fraud_prevention')->where('id', 1)->get();

            if ($secure['clone'] == 'true' && $prevention[0]->app_clonning == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Clone App.', 'code' => 401]);
            }

            if ($secure['emu'] == 'true' && $prevention[0]->block_emulator == 'true') {
                $this->logmonitor($user->cust_id, "Emulator Device Used.");
                return response()->json(['message' => 'Security Reason You Cant Use App on Emulator.', 'code' => 401]);
            }

            if ($secure['termux'] == 'true' && $prevention[0]->block_termux == 'true') {
                return response()->json(['message' => 'Termux App Detected!! Uninstall to Use App', 'code' => 401]);
            }

            if ($secure['devMode'] == 'false' && $prevention[0]->block_devMode == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Use App on Developer Mode On.', 'code' => 401]);
            }

            if ($prevention[0]->vpn_required == 'true') {
                
                if($secure['vpn'] != true){
                    return response()->json(['message' => $prevention[0]->vpn_required_msg, 'code' => 401]);
                }
            }

            if ($secure['vpn'] == 'true') {

                if ($prevention[0]->auto_banVpn == 'true') {
                    $this->logmonitor($user->cust_id, "VPN Used.");
                    $this->banuser($user->cust_id, "Account Banned for Security Reason VPN Used.");
                    return response()->json(['message' => 'Account Banned for Security Reason VPN Used.', 'code' => 401]);
                }

                if ($prevention[0]->block_vpn == 'true') {
                    return response()->json(['message' => 'Security Reason You Cant Use App with VPN.', 'code' => 401]);
                }

                if ($prevention[0]->vpn_monitor == 'true') {
                    $this->logmonitor($user->cust_id, "VPN Used.");
                }
            }

            if ($secure['root'] == 'true') {
                $this->logmonitor($user->cust_id, "Root Device.");

                if ($prevention[0]->auto_banroot == 'true') {
                    $this->banuser($user->cust_id, "Account Banned for Security Reason Rooted Device.");
                    return response()->json(['message' => 'Account Banned for Security Reason Used Rooted Device.', 'code' => 401]);
                }

                if ($prevention[0]->block_root_device == 'true') {
                    return response()->json(['message' => 'Security Reason You Cant Use App on Rooted Device.', 'code' => 401]);
                }
            }

            if ($user->status == 1) {
                return response()->json(['message' => $user->reason, 'code' => 401]);
            }

            if ($user->updated_at != date('Y-m-d')) {
                Users::where('cust_id', $user->cust_id)->update(['updated_at' => Carbon::now()]);
            }

            $task = TaskCount::where('user_id', $user->cust_id)->first();
            if (is_null($task)) {
                DB::table('task_count')->insert(['user_id' => $user->cust_id]);
            }

            return $this->createNewTokenGoogle($user, $token);
        } else {

            $validator = Validator::make($req, [
                'name' => 'required|string|between:4,100',
                'email' => 'required|string|email|max:100|unique:users',
            ]);


            if ($validator->fails()) {
                return response()->json(['message' => $validator->errors()->first(), 'code' => 401]);
            }

            geoip()->getLocation(null);
            $ip = UserAuth::getUserIpAddr();
            $arr_ip = geoip()->getLocation($ip);

            $prevention = DB::table('fraud_prevention')->where('id', 1)->get();
            if ($prevention[0]->block_country == 'true' && $prevention[0]->block_country_iso != null) {
                $iso = $prevention[0]->block_country_iso;
                $ar = explode(",", $iso);
                if (in_array($arr_ip->iso_code, $ar)) {
                    return response()->json(['message' => $prevention[0]->block_country_msg, 'code' => 401]);
                }
            }

            $cdip = Users::where('ip', $ip)->count();
            if ($cdip >= $prevention[0]->oneip_device) {
                return response()->json(['message' => 'Account Create Limit Reached.', 'code' => 401]);
            }

            if ($prevention[0]->onedevice == 'true') {
                if ($cd = Users::where('token', $secure['token'])->select('email')->first()) {
                    return response()->json(['message' => 'Account Already Exist ' . $cd->email, 'code' => 401]);
                }
            }


            if ($secure['clone'] == 'true' && $prevention[0]->app_clonning == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Clone App.', 'code' => 401]);
            }

            if ($secure['emu'] == 'true' && $prevention[0]->block_emulator == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Use App on Emulator.', 'code' => 401]);
            }

            if ($secure['termux'] == 'true' && $prevention[0]->block_termux == 'true') {
                return response()->json(['message' => 'Termux App Detected!! Uninstall to Use App', 'code' => 401]);
            }

            if ($secure['devMode'] == 'false' && $prevention->block_devMode == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Use App on Developer Mode On.', 'code' => 401]);
            }

            if ($secure['root'] == 'true' && $prevention[0]->block_root_device == 'true') {
                return response()->json(['message' => 'Security Reason You Cant Use App on Rooted Device.', 'code' => 401]);
            }
            
            
            $refer=false;
            $refid="";
            if($secure['ref']!=null){
                if ($checkRef = Users::where('refferal_id', $secure['ref'])->first()) {
                    $refid=$secure['ref'];
                   $refer=true; 
                }
            }


            $user               =       new Users;
            $user->name         =       $req['name'];
            $user->email        =       $req['email'];
            $user->token        =       $secure['token'];
            $user->person_id    =       $req['person_id'];
            $user->profile      =       $secure['profile'];
            $user->p_token      =       $req['p_token'];
            $user->type         =       "google";
            $user->refferal_id  =       UserAuth::genUserCode();
            $user->ip           =       $ip;
            $user->country      =       $arr_ip->iso_code;
            $user->save();

            $task = TaskCount::where('user_id', $user->cust_id)->first();
            if (is_null($task)) {
                DB::table('task_count')->insert(['user_id' => $user->cust_id]);
            }
            
            if($refer){
                $user=Users::find($user->cust_id);
                $setting = DB::table('tbl_app_setting')->where('id', 1)->select('welcome_bonus', 'refer_mode')->get();
                $bonus = $setting[0]->welcome_bonus;
            
                $wb = explode('-', $setting[0]->welcome_bonus);
    
                if ($setting[0]->refer_mode == "direct") {
                    $coin = $wb[1];
                } else {
                    $coin = $wb[1] / 2;
                }
    
                $coin = rand($wb[0], $coin);
                
                $user->from_refferal_id = $refid;
                if ($setting[0]->refer_mode == "direct") {
                    $sub = _Subscriptions::where('id', $checkRef->subscription)->select('refer_bonus')->get();
                    $exp = explode("-", $sub[0]->refer_bonus);
                    $fromcoin = rand($exp[0], $exp[1]);

                    DB::table('scratch_card')->insert([
                        'user_id' => $checkRef->cust_id,
                        'coin' => $fromcoin,
                        'remark' => 'Referral Bonus Credit From ' . $checkRef->name
                    ]);
                    
                    if($crnt=DB::table('contest_record')->where('user_id',$checkRef->cust_id)->whereDate('created_at',date('Y-m-d'))->first()){
                          DB::table('contest_record')->where('id',$crnt->id)->update([
                                        'user_id' =>$checkRef->cust_id,
                                        'to_user_id' =>$user->cust_id,
                                        'task_count' =>($crnt->task_count+1),
                                    ]);
                      }else{
                            DB::table('contest_record')->insert([
                                        'user_id' =>$checkRef->cust_id,
                                        'to_user_id' => '1',
                                        'task_count' =>1,
                                    ]);
                        }

                    DB::table('global_msg')->insert([
                        'user_id' => $checkRef->cust_id,
                        'title' => 'Congratulations',
                        'msg' => 'You Won Scratch Card for Invite your friend ' . $checkRef->name,
                        'btn_name' => 'Open Scratch Card',
                        'btn_action' => 'invite',
                        'error' => 'false'
                    ]);

                    $user->refer = true;
                  DB::table('scratch_card')->insert(['user_id' => $user->cust_id, 'coin' => $coin, 'remark' => 'Welcome Bonus']);

                }
                else{
                    
                    $exp = explode("-", $sub[0]->welcome_bonus);
                    $fromcoin = rand($exp[0], $exp[1]);
                    
                    DB::table('global_msg')->insert([
                        'user_id' => $user->cust_id,
                        'title' => 'Congratulations',
                        'msg' => 'You Won Scratch Card from your Friend ' . $checkRef->name,
                        'btn_name' => 'Open Scratch Card',
                        'btn_action' => 'invite',
                        'error' => 'false'
                    ]);

                    $user->refer = true;
                    DB::table('scratch_card')->insert(['user_id' => $user->cust_id, 'coin' => $coin, 'remark' => 'Welcome Bonus Part 1']);

                }
                $user->save();
            }

            $usr = Users::where('cust_id', $user->cust_id)->first();
            try {
                if (!$token = JWTAuth::fromUser($usr)) {
                    return response()->json([
                        'code' => 401,
                        'message' => 'Login credentials are invalid.',
                    ]);
                }
            } catch (JWTException $e) {
                return $credentials;
                return response()->json([
                    'code' => 401,
                    'message' => 'Could not create.',
                ]);
            }

            if ($user->updated_at != date('Y-m-d')) {
                Users::where('cust_id', $user->cust_id)->update(['updated_at' => Carbon::now()]);
            }
            return $this->createNewTokenGoogle($usr, $token);
        }
    }

    protected function createNewTokenGoogle($user, $token)
    {
        return response()->json([
            'resp' => $token . $user->refferal_id,
            'user' => $user,
            'message' => 'Login Successfull',
            'code' => 201,
            'noti' => $this->notiCount($user->cust_id)
        ]);
    }


    public function getUserIpAddr()
    {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if (isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if (isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if (isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }

    public function genUserCode()
    {
        $this->refferal_id = [
            'refferal_id' => mt_rand(123456, 999999)
        ];

        $rules = ['refferal_id' => 'unique:customer'];

        $validate = Validator::make($this->refferal_id, $rules)->passes();

        return $validate ? $this->refferal_id['refferal_id'] : $this->genUserCode();
    }

    function banuser($userid, $reason)
    {
        $user = Users::find($userid);
        $user->status = 1;
        $user->balance = 0;
        $user->reason = $reason;
        $user->banned_time = Carbon::now();
        $user->save();
        DB::table('monitor_report')->insert(['userid' => $userid, 'type' => 'Acctoun Ban','remark'=>$reason]);
    }

    function logmonitor($userid, $type)
    {
        DB::table('monitor_report')->insert(['userid' => $userid, 'type' => $type]);
    }

    public function logout()
    {
        auth()->logout();
        return response()->json(['message' => 'User successfully signed out']);
    }

    public function refresh()
    {
        return $this->createNewToken(auth()->refresh());
    }

    public function userProfile()
    {

        return response()->json(auth()->user());
    }

    public function accountHistory($id)
    {
        $data = DB::table('transaction')->where('user_id',$id)->orderBy('id', 'DESC')->select('tran_type', 'type', 'amount', 'remarks', 'inserted_at')->limit(40)->get();
        return response()->json($data);
    }

    public function rewardHistory($id)
    {
        $data = DB::table('recharge_request')->where('user_id',$id)->orderBy('request_id', 'DESC')->select('request_id', 'mobile_no', 'type', 'amount', 'updated_at', 'status', 'remarks', 'date')->limit(10)->get();
        return response()->json($data);
    }

    public function guard()
    {
        return Auth::guard();
    }

    protected function createNewToken($token)
    {
        return response()->json([
            'resp' => $token . auth()->user()->refferal_id,
            'user' => auth()->user(),
            'message' => 'Login Successfull',
            'code' => 201,
            'noti' => $this->notiCount(auth()->user()->cust_id)
        ]);
    }


    public function IpAddr()
    {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if (isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if (isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if (isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }

    function notiCount($id)
    {
        $global=DB::table('tbl_noti')->where(['user_id' =>0])->whereDate('created_at',date('Y-m-d'))->count();    
        $usr=DB::table('tbl_noti')->where(['user_id' => $id, 'noti_type' => 0, 'status' => 0])->count();
        return (int)($global+$usr);
    }

    public function reset_password(Request $req)
    {

        if ($req->type == "reset") {
            $appname = config('app.name');
            $valideator = Validator::make($req->all(), [
                'email'    => 'email|exists:customer'
            ], [
                'email.email' => 'Enter Valid Email !',
                'email.exists' => 'Email Not Found !'
            ]);


            if ($valideator->fails()) {
                return response()->json(['msg' => $valideator->errors()->first(), 'code' => 404]);
            }

            $cnt = DB::table('customer')->where('email', $req->email)->get()->first()->type;
            if ($cnt == "google") {
                return response()->json(['msg' => 'Account linked with Google login', 'code' => 404]);
            }


            $otp = mt_rand(1234, 9999);

            $details = [
                'title' => $appname,
                'body' => 'Your Password Reset OTP is ' . $otp
            ];
            Mail::to($req->email)->send(new NotifyMail($details));
            DB::table('password_reset')->insert(
                ['email' => $req->email, 'token' => '', 'otp' => $otp]
            );

            return response(['code' => 201, 'msg' => 'OTP has been Sent To Your Mail']);
        } else {
            $appname = config('app.name');
            $valideator = Validator::make($req->all(), [
                'email'    => 'email|exists:customer'
            ], [
                'email.email' => 'Enter Valid Email !',
                'email.exists' => 'Email Not Found !'
            ]);

            if ($valideator->fails()) {
                return response()->json(['msg' => $valideator->errors()->first(), 'code' => 404]);
            }

            $otp = mt_rand(1234, 9999);

            $details = [
                'title' => $appname,
                'body' => 'Your Email Verification OTP is ' . $otp
            ];
            Mail::to($req->email)->send(new NotifyMail($details));
            DB::table('password_reset')->insert(
                ['email' => $req->email, 'token' => '', 'otp' => $otp]
            );

            return response(['code' => 201, 'msg' => 'OTP has been Sent To Your Mail']);
        }
    }


    public function verify_otp(Request $req)
    {
        $otp = $req->otp;
        $dataotp = DB::table('password_reset')->where('email', $req->email)->orderBy('id', 'DESC')->limit(1)->get()->first()->otp;

        if ($otp == $dataotp) {
            return response()->json(['code' => 201, 'data' => $dataotp, 'msg' => 'Otp verified']);
        } else {
            return response()->json(['code' => 400, 'msg' => 'Wrong OTP']);
        }
    }

    public function update_password(Request $req)
    {
        $data = Users::where('email', $req->email)->get();
        $userid = $data[0]->cust_id;

        $otp = $req->otp;
        $dataotp = DB::table('password_reset')->where('email', $req->email)->orderBy('id', 'DESC')->limit(1)->get()->first()->otp;

        if ($otp != $dataotp) {
            return response()->json(['code' => 400, 'msg' => 'Wrong OTP']);
        }

        $update = Users::find($userid);
        $update->password = Hash::make($req->password);
        $update->save();
        if ($update) {
            return response()->json(['msg' => 'Password Updated Successfully Login Now', 'code' => 201]);
        } else {
            return response()->json(['msg' => 'Error to Update Password', 'code' => 400]);
        }
    }
}
