<?php

namespace App\Http\Controllers;

use App\Models\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class UsersController extends Controller
{
    public function index()
    {
        if(auth()->user()->id>'1'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        $data =  User::paginate(15);
        return view('admin-setting/admin/admin', compact('data'));
    }

    public function store(Request $req)
    {
        if(auth()->user()->id>'1'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        $validator = Validator::make($req->all(), [
            'username' => ['required'],
            'email' => ['required', 'email', 'max:50', Rule::unique('users', 'email')],
            'password' => ['required', 'min:5', 'max:20'],
            'role_edit' => ['required'],
            'role_delete' => ['required'],
            'role_create' => ['required'],
            'role_userlist' => ['required'],
        ]);
        
        if($validator->fails()){
            return redirect()->back()->withErrors(['msgError' =>$validator->errors()]);
        }
        
        $user = new User;
        $user->username=$req->username;
        $user->email=$req->email;
        $user->password= Hash::make($req->password);
        $user->role_edit=$req->role_edit;
        $user->role_delete=$req->role_delete;
        $user->role_create=$req->role_create;
        $user->role_userlist=$req->role_userlist;
        $res=$user->save();
        
        if($res){
          return redirect('/admin')->with('success', 'Admin Added Successfully');
        }else{
           return redirect()->back()->withErrors(['msgError' =>'Something went wrong!!']);
        }
        
    }
    
    public function edit(User $id){
        return view('admin-setting/admin/edit',['data'=>$id]);        
    }
    
    public function update(Request $req,User $user)
    {
        if(auth()->user()->id>'1'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        $validatedData = Validator::make($req->all(), [
            'username' => ['required'],
            'email' => ['required', 'email'],
            'password' => ['required'],
            'role_edit' => ['required'],
            'role_delete' => ['required'],
            'role_create' => ['required'],
            'role_userlist' => ['required'],
        ]);
        
        if($validatedData->fails()){
            return redirect()->back()->withErrors(['msgError' =>$validatedData->errors()]);
        }
        
        $user = User::find($req->id);
        $user->username=$req->username;
        $user->email=$req->email;
        if($user->password!=$req->password){
            $user->password= Hash::make($req->password);
        }
        $user->role_edit=$req->role_edit;
        $user->role_delete=$req->role_delete;
        $user->role_create=$req->role_create;
        $user->role_userlist=$req->role_userlist;
        $res=$user->save();
        
        if($res){
          return redirect('/admin')->with('success', 'Admin Updated Successfully');
        }else{
           return redirect()->back()->withErrors(['msgError' =>'Something went wrong!!']);
        }
        
    }
    
    public function destroy($id){
        if(auth()->user()->id>'1'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        User::find($id)->delete();
        return redirect('/admin')->with('success', 'Deleted Successfully');
    }

}
