@extends('user_type.auth', ['parentFolder' => 'subscriptions', 'childFolder' => ''])

@section('content')
<main class="main-content mt-1 border-radius-lg">
    
    <div class="container-fluid py-4">
        @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
        <div class="row">
            <div class="col-9 mx-auto">
                <div class="card card-body mt-4">
                    <h6 class="mb-0">New Subscriptions PLAN</h6>
                    <p class="text-sm mb-0">Create New Subscriptions</p>
                    <hr class="horizontal dark my-3">
                    <form action="/subscriptions/store" method="POST"  enctype="multipart/form-data">
                        @csrf
                        
                        <div class="form-group">
                            <label for="categoryName" class="form-label">Subscriptions Badge</label>
                            <div class="">
                                <input type="file" class="form-control " name="icon" onfocus="focused(this)" onfocusout="defocused(this)" required>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="categoryName" class="form-label">Subscriptions Name</label>
                            <div class="">
                                <input type="text" class="form-control " value="{{ old('title') }}"  placeholder="Gold Plan" name="title" onfocus="focused(this)" onfocusout="defocused(this)" required>
                                @error('name')
                                    <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="categoryName" class="form-label">Subscriptions Validity</label>
                            <div class="">
                                <select name="valid_for" class="form-control" required>
                                    <option value="1">1 Month</option>
                                    <option value="2">2 Month</option>
                                    <option value="3">3 Month</option>
                                    <option value="4">4 Month</option>
                                    <option value="6">6 Month</option>
                                    <option value="8">8 Month</option>
                                    <option value="12">12 Month</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="categoryName" class="form-label">Description Max 2-3 line</label>
                            <div class="">
                                <textarea class="form-control" placeholder="Description" name="description" rows="4" required></textarea>
                                @error('name')
                                    <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                    

                        <div class="form-group">
                            <label for="categoryName" class="form-label">Subscriptions PRICE IN USD </label>
                            <div class="">
                                <input type="number" class="form-control " placeholder="1" name="amount" onfocus="focused(this)" onfocusout="defocused(this)" required>
                                @error('name')
                                    <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="categoryName" class="form-label">Currency Name ( User will be pay in this currency)</label>
                            <div class="">
                                <input type="text" class="form-control" placeholder="USD,INR" name="currency" value="USD" onfocus="focused(this)" onfocusout="defocused(this)" required>
                                @error('currency')
                                    <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="categoryName" class="form-label">Currency Tag Position </label>
                            <div class="">
                                <select name="currency_posi" class="form-control">
                                    <option value="0">Show Before Amount Like USD 2</option>
                                    <option value="1">Show After Amount Like 2 USD</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="categoryName" class="form-label">Available Country List ( Note : if you want to allow in all country just add => all)</label>
                            <div class="">
                                <input type="text" class="form-control " placeholder="Us,IN" value="all" name="country" onfocus="focused(this)" onfocusout="defocused(this)" required>
                                @error('country')
                                    <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <br>
                        <h6>Promo Coin & Refferal Bonus user can earn</h6>
                        <hr>
                        
                        <div class="row">
                            <div class="col-sm-4 col-lg-4">
                                <label class="form-label "><label class="text-info text-sm m-0">Refferal Bonus</label> upto</label>
                                <div class="input-group">
                                    <input class="form-control" type="text"  name="refer_bonus" placeholder="50-100"  required>
                                </div>
                            </div>
                            
                            <div class="col-sm-4 col-lg-4">
                                <label class="form-label"><label class="text-info text-sm m-0">Promo Coin </label> (This Coin used only for promotion user can't redeem )</label>
                                <div class="input-group">
                                    <input class="form-control" type="number" name="promo_coin" onfocus="focused(this)" onfocusout="defocused(this)" placeholder="100"  required>
                                </div>
                            </div>
                        </div>

                        
                        <br>
                        <h6>Task Limit Apply in this Subscription</h5>
                        <hr>

                        <div class="row">
                            <div class="col-sm-4 col-lg-4">
                                <label class="form-label "><label class="text-info text-sm m-0">Article </label> Task Daily Limit </label>
                                <div class="input-group">
                                    <input type="number" class="form-control " placeholder="1" name="task_web"  onfocus="focused(this)" onfocusout="defocused(this)" required>
                                </div>
                            </div>
                            
                            <div class="col-sm-4 col-lg-4">
                                <label class="form-label "><label class="text-info text-sm m-0">VIDEO </label> Task Daily Limit </label>
                                <div class="input-group">
                                <input type="number" class="form-control " placeholder="1" name="task_video"  onfocus="focused(this)" onfocusout="defocused(this)" required>
                                </div>
                            </div>
                            
                             <div class="col-sm-4 col-lg-4">
                                <label class="form-label "><label class="text-info text-sm m-0">VIDEOZONE(Rewarded Ads) </label> Task Daily Limit </label>
                                <div class="input-group">
                                <input type="number" class="form-control " placeholder="1" name="task_videozone" onfocus="focused(this)" onfocusout="defocused(this)" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-2">
                            <div class="col-sm-4 col-lg-4">
                                <label class="form-label "><label class="text-info text-sm m-0">MATH QUIZ </label> Task Daily Limit </label>
                                <div class="input-group">
                                <input type="number" class="form-control " placeholder="1" name="task_quiz"   onfocus="focused(this)" onfocusout="defocused(this)" required>
                                </div>
                            </div>
                            
                            <div class="col-sm-4 col-lg-4">
                                <label class="form-label "><label class="text-info text-sm m-0">Daily OFFER </label> Task Daily Limit </label>
                                <div class="input-group">
                                <input type="number" class="form-control " placeholder="1" name="task_daily_offer"  onfocus="focused(this)" onfocusout="defocused(this)" required>
                                </div>
                            </div>
                            
                             <div class="col-sm-4 col-lg-4">
                                <label class="form-label "><label class="text-info text-sm m-0">SPIN </label> Task Daily Limit </label>
                                <div class="input-group">
                                <input type="number" class="form-control " placeholder="1" name="task_spin"  onfocus="focused(this)" onfocusout="defocused(this)" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-2">
                            <div class="col-sm-4 col-lg-4">
                                <label class="form-label "><label class="text-info text-sm m-0">SCRATCH </label> Task Daily Limit </label>
                                <div class="input-group">
                                <input type="number" class="form-control " placeholder="1" name="task_scratch"  onfocus="focused(this)" onfocusout="defocused(this)" required>
                                </div>
                            </div>
                          
                        </div>
                        
                        <div class="d-flex justify-content-end mt-4">
                            <a href="{{ url('/subscriptions') }}" type="button" name="button" class="btn btn-light m-0">BACK TO LIST</a>
                            <button type="submit" name="button" class="btn bg-gradient-primary m-0 ms-2">Create </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</main>
@endsection